/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.common.service.cache.decorator;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bndly.common.reflection.ReflectionUtil;
import org.bndly.common.service.cache.AbstractKeyParameter;
import org.bndly.common.service.cache.ChainedCache;
import org.bndly.common.service.cache.EntityIdentityKeyParameter;
import org.bndly.common.service.cache.SimpleKeyParameter;
import org.bndly.common.service.cache.api.ApplicationCache;
import org.bndly.common.service.cache.api.Cache;
import org.bndly.common.service.cache.api.CacheKey;
import org.bndly.common.service.cache.api.CacheKeyParameter;
import org.bndly.common.service.cache.api.CacheKeyProvider;
import org.bndly.common.service.cache.api.CacheLevel;
import org.bndly.common.service.cache.api.CacheLocaleProvider;
import org.bndly.common.service.cache.api.Cached;
import org.bndly.common.service.cache.api.EntityCache;
import org.bndly.common.service.cache.api.EntityCacheKey;
import org.bndly.common.service.cache.api.KeyParameter;
import org.bndly.common.service.cache.api.MethodInvocationCacheKey;
import org.bndly.common.service.cache.api.RequestCache;
import org.bndly.common.service.cache.keys.EntityCacheKeyImpl;
import org.bndly.common.service.cache.keys.LocalizedEntityCacheKeyImpl;
import org.bndly.common.service.cache.keys.LocalizedMethodInvocationCacheKeyImpl;
import org.bndly.common.service.cache.keys.MethodInvocationCacheKeyImpl;
import org.bndly.common.service.decorator.api.ServiceDecorator;
import org.bndly.common.service.decorator.api.ServiceDecoratorChain;
import org.bndly.common.service.model.api.Identity;
import org.bndly.common.service.model.api.IdentityBuilder;
import org.bndly.common.service.model.api.ReferableResource;

public class CacheServiceDecorator
implements ServiceDecorator {
    private RequestCache requestCache;
    private ApplicationCache applicationCache;
    private EntityCache entityCache;
    private CacheLocaleProvider cacheLocaleProvider;

    private Method getReallyInvokedMethod(Method method, Object wrappedInstance) {
        Class<?> instanceType;
        List methods;
        Method invoked = method;
        Cached cachedAnnotation = method.getAnnotation(Cached.class);
        if (cachedAnnotation == null && (methods = ReflectionUtil.listAnnotatedMethodsImplementedBy(instanceType = wrappedInstance.getClass(), Cached.class)) != null) {
            for (Method m : methods) {
                if (!m.getName().equals(method.getName()) || m.getParameterTypes().length != method.getParameterTypes().length) continue;
                invoked = m;
                break;
            }
        }
        return invoked;
    }

    private Cached getCachedAnnotationForMethod(Method method, Object wrappedInstance) {
        return this.getReallyInvokedMethod(method, wrappedInstance).getAnnotation(Cached.class);
    }

    public boolean appliesTo(Method method, Object wrappedInstance) {
        CacheLevel[] levels;
        boolean returnsSomething;
        Cached cachedAnnotation = this.getCachedAnnotationForMethod(method, wrappedInstance);
        if (cachedAnnotation == null) {
            return false;
        }
        boolean bl = returnsSomething = !method.getReturnType().equals(Void.class);
        if (!returnsSomething) {
            return false;
        }
        boolean requestCachingSupported = false;
        boolean applicationCachingSupported = false;
        boolean entityCachingSupported = false;
        for (CacheLevel cacheLevel : levels = cachedAnnotation.levels()) {
            if (CacheLevel.REQUEST.equals((Object)cacheLevel) && this.requestCache != null) {
                requestCachingSupported = true;
            }
            if (CacheLevel.APPLICATION.equals((Object)cacheLevel) && this.applicationCache != null) {
                applicationCachingSupported = true;
            }
            if (!CacheLevel.ENTITY.equals((Object)cacheLevel) || this.entityCache == null) continue;
            applicationCachingSupported = true;
        }
        return requestCachingSupported || applicationCachingSupported || entityCachingSupported;
    }

    public boolean precedes(ServiceDecorator decorator) {
        return decorator.getClass().getSimpleName().equals("InvocationServiceDecorator");
    }

    public Object execute(ServiceDecoratorChain decoratorChain, Object invocationTarget, Method interfaceMethod, Object ... args) throws Throwable {
        Method invokedMethod = this.getReallyInvokedMethod(interfaceMethod, invocationTarget);
        final String methodName = invocationTarget.getClass().getSimpleName() + "." + invokedMethod.getName();
        final ArrayList<SimpleKeyParameter> parameters = new ArrayList<SimpleKeyParameter>();
        Class returnedEntityType = invokedMethod.getReturnType();
        if (Collection.class.isAssignableFrom(returnedEntityType)) {
            returnedEntityType = ReflectionUtil.getCollectionParameterType((Type)invokedMethod.getGenericReturnType());
        }
        final String returnedEntityTypeName = returnedEntityType.getName();
        Annotation[][] allParameterAnnotations = invokedMethod.getParameterAnnotations();
        Class<?>[] allParameterTypes = invokedMethod.getParameterTypes();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                AbstractKeyParameter param;
                Object parameterValue = args[i];
                Annotation[] annotationArray = allParameterAnnotations[i];
                CacheKeyParameter cacheKeyParameterAnnotation = null;
                for (Annotation annotation : annotationArray) {
                    if (!CacheKeyParameter.class.isInstance(annotation)) continue;
                    cacheKeyParameterAnnotation = (CacheKeyParameter)annotation;
                    break;
                }
                if (cacheKeyParameterAnnotation == null) continue;
                String parameterName = cacheKeyParameterAnnotation.value();
                if (ReferableResource.class.isInstance(parameterValue)) {
                    Identity identity = IdentityBuilder.buildOrIdentity((Object)parameterValue);
                    if (identity == null) continue;
                    param = new EntityIdentityKeyParameter(parameterName, identity);
                } else {
                    param = new SimpleKeyParameter(parameterName, parameterValue);
                }
                parameters.add((SimpleKeyParameter)param);
            }
        }
        Identity entityIdentityCandidate = null;
        for (KeyParameter keyParameter : parameters) {
            if (!EntityIdentityKeyParameter.class.isInstance(keyParameter)) continue;
            entityIdentityCandidate = (Identity)((EntityIdentityKeyParameter)EntityIdentityKeyParameter.class.cast(keyParameter)).getValue();
        }
        final Identity passedInEntityIdentity = entityIdentityCandidate;
        final boolean bl = this.isLocalizedMethod(invokedMethod);
        CacheKeyProvider cacheKeyProvider = new CacheKeyProvider(){

            public <T extends CacheKey> T getKey(Class<T> cacheKeyType) {
                String locale = null;
                if (bl) {
                    locale = CacheServiceDecorator.this.assertCurrentLocaleIsDefined();
                }
                if (MethodInvocationCacheKey.class.isAssignableFrom(cacheKeyType)) {
                    if (bl) {
                        return (T)new LocalizedMethodInvocationCacheKeyImpl(methodName, parameters, locale);
                    }
                    return (T)new MethodInvocationCacheKeyImpl(methodName, parameters);
                }
                if (EntityCacheKey.class.isAssignableFrom(cacheKeyType)) {
                    if (passedInEntityIdentity == null) {
                        throw new IllegalStateException("trying to build a " + EntityCacheKey.class.getSimpleName() + " but there where no " + CacheKeyParameter.class.getSimpleName() + " annotations found or the annotated parameter was null or the annotated parameter could not return any identity.");
                    }
                    if (bl) {
                        return (T)new LocalizedEntityCacheKeyImpl(returnedEntityTypeName, passedInEntityIdentity, locale);
                    }
                    return (T)new EntityCacheKeyImpl(returnedEntityTypeName, passedInEntityIdentity);
                }
                throw new IllegalArgumentException("unsupported cache key type: " + cacheKeyType.getName());
            }
        };
        Cached cachedAnnotation = this.getCachedAnnotationForMethod(invokedMethod, invocationTarget);
        Cache cacheChain = this.getCacheForMethod(cachedAnnotation);
        if (cacheChain.existsInCache(cacheKeyProvider)) {
            return cacheChain.getCachedValue(cacheKeyProvider);
        }
        Object result = decoratorChain.doContinue();
        cacheChain.storeValue(cacheKeyProvider, result);
        this.insertResultToEntityCache(result, bl);
        return result;
    }

    private String assertCurrentLocaleIsDefined() throws IllegalStateException {
        if (this.cacheLocaleProvider == null) {
            throw new IllegalStateException("can't use a localized cache, when there is no cacheLocaleProvider in the application context.");
        }
        String locale = this.cacheLocaleProvider.getCacheLocale();
        if (locale == null) {
            throw new IllegalStateException("cacheLocaleProvider did return null as a locale.");
        }
        return locale;
    }

    private boolean isLocalizedMethod(Method invokedMethod) {
        Cached cachedAnnotation = invokedMethod.getAnnotation(Cached.class);
        if (cachedAnnotation != null) {
            return cachedAnnotation.localized();
        }
        return false;
    }

    private Cache getCacheForMethod(Cached cachedAnnotation) {
        CacheLevel[] levels = cachedAnnotation.levels();
        ArrayList<Cache> caches = new ArrayList<Cache>();
        for (CacheLevel cacheLevel : levels) {
            if (CacheLevel.REQUEST.equals((Object)cacheLevel)) {
                caches.add((Cache)this.requestCache);
                continue;
            }
            if (CacheLevel.APPLICATION.equals((Object)cacheLevel)) {
                caches.add((Cache)this.applicationCache);
                continue;
            }
            if (!CacheLevel.ENTITY.equals((Object)cacheLevel)) continue;
            caches.add((Cache)this.entityCache);
        }
        return new ChainedCache(caches);
    }

    private void insertResultToEntityCache(Object result, boolean localized) {
        if (this.entityCache != null && result != null) {
            if (ReferableResource.class.isInstance(result)) {
                this.addReferableResourceToEntityCache((ReferableResource)result, localized);
            } else if (Collection.class.isInstance(result)) {
                Collection c = (Collection)result;
                for (Object object : c) {
                    if (!ReferableResource.class.isInstance(object)) continue;
                    this.addReferableResourceToEntityCache((ReferableResource)object, localized);
                }
            }
        }
    }

    private void addReferableResourceToEntityCache(ReferableResource rr, boolean localized) {
        String locale = null;
        if (localized) {
            locale = this.assertCurrentLocaleIsDefined();
        }
        if (this.entityCache != null && rr != null) {
            String returnedEntityTypeName = rr.getClass().getName();
            List identities = IdentityBuilder.buildAllPossible((Object)rr);
            if (identities != null && !identities.isEmpty()) {
                for (Identity identity : identities) {
                    EntityCacheKeyImpl k = localized ? new LocalizedEntityCacheKeyImpl(returnedEntityTypeName, identity, locale) : new EntityCacheKeyImpl(returnedEntityTypeName, identity);
                    final EntityCacheKeyImpl key = k;
                    this.entityCache.storeValue(new CacheKeyProvider(){

                        public <T extends CacheKey> T getKey(Class<T> cacheKeyType) {
                            return (T)key;
                        }
                    }, (Object)rr);
                }
            }
        }
    }

    public void setApplicationCache(ApplicationCache applicationCache) {
        this.applicationCache = applicationCache;
    }

    public void setEntityCache(EntityCache entityCache) {
        this.entityCache = entityCache;
    }

    public void setRequestCache(RequestCache requestCache) {
        this.requestCache = requestCache;
    }

    public void setCacheLocaleProvider(CacheLocaleProvider cacheLocaleProvider) {
        this.cacheLocaleProvider = cacheLocaleProvider;
    }
}

