/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.common.service.cache;

import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.bndly.common.service.cache.api.Cache;
import org.bndly.common.service.cache.api.CacheKey;
import org.bndly.common.service.cache.api.CacheKeyProvider;

public abstract class EHCacheWrapperImpl
implements Cache {
    private Ehcache ehCache;

    public EHCacheWrapperImpl() {
    }

    public EHCacheWrapperImpl(Ehcache cache) {
        this.ehCache = cache;
    }

    protected abstract Class<? extends CacheKey> getCacheKeyType();

    public boolean existsInCache(CacheKeyProvider key) {
        CacheKey k = key.getKey(this.getCacheKeyType());
        Element element = this.ehCache.get((Object)k);
        return element != null;
    }

    public Object getCachedValue(CacheKeyProvider key) {
        Element el = this.ehCache.get((Object)key.getKey(this.getCacheKeyType()));
        if (el == null) {
            return null;
        }
        return el.getObjectValue();
    }

    public void storeValue(CacheKeyProvider key, Object value) {
        CacheKey k = key.getKey(this.getCacheKeyType());
        this.ehCache.put(new Element((Object)k, value));
    }

    public void setEhCache(Ehcache ehCache) {
        this.ehCache = ehCache;
    }
}

