/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.common.service.client.dao;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.bndly.common.service.client.dao.DefaultDao;
import org.bndly.common.service.client.dao.DefaultDaoImpl;
import org.bndly.common.service.client.dao.Initializer;
import org.bndly.common.service.client.dao.LazyDefaultDao;
import org.bndly.rest.atomlink.api.JAXBMessageClassProvider;
import org.bndly.rest.client.api.HATEOASClient;
import org.bndly.rest.client.api.ServiceFactory;
import org.bndly.rest.client.exception.ClientException;
import org.bndly.rest.schema.beans.SchemaBean;
import org.bndly.rest.schema.beans.SchemaList;
import org.bndly.rest.schema.beans.TypeBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaBeanDaoFactory {
    private Future<?> initFuture;
    private Future<?> finishedInitFuture;
    private static final Logger LOG = LoggerFactory.getLogger(SchemaBeanDaoFactory.class);
    private final String schemaName;
    private final String schemaRestBeanPackage;
    private final Map<String, DefaultDao> daosByTypeName = new HashMap<String, DefaultDao>();
    private final Map<Class<?>, DefaultDao> daosByRestBeanType = new HashMap();
    private ServiceFactory serviceFactory;
    private final ExecutorService initExecutor = Executors.newSingleThreadExecutor();
    private JAXBMessageClassProvider messageClassProvider;

    public SchemaBeanDaoFactory(String schemaName, String schemaRestBeanPackage) {
        if (schemaName == null) {
            throw new IllegalArgumentException("schemaName is not allowed to be null");
        }
        this.schemaName = schemaName;
        if (schemaRestBeanPackage == null) {
            throw new IllegalArgumentException("schemaRestBeanPackage is not allowed to be null");
        }
        this.schemaRestBeanPackage = schemaRestBeanPackage;
    }

    public Future<?> init(final Listener ... listeners) {
        Runnable initRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    if (SchemaBeanDaoFactory.this.messageClassProvider == null) {
                        LOG.error("no messageClassProvider configured");
                        return;
                    }
                    Collection classes = SchemaBeanDaoFactory.this.messageClassProvider.getJAXBMessageClasses();
                    HashMap<String, Class> classesByName = new HashMap<String, Class>();
                    for (Class cls : classes) {
                        classesByName.put(cls.getName(), cls);
                    }
                    HATEOASClient client = SchemaBeanDaoFactory.this.serviceFactory.getServiceClient("schema", SchemaList.class);
                    SchemaList schemaList = (SchemaList)client.getWrappedBean();
                    String packagePrefix = SchemaBeanDaoFactory.this.schemaRestBeanPackage + ".";
                    for (SchemaBean schemaBean : schemaList) {
                        if (!schemaBean.getName().equals(SchemaBeanDaoFactory.this.schemaName)) continue;
                        for (Listener listener : listeners) {
                            listener.onSchemaLoaded(schemaBean);
                        }
                        for (final TypeBean typeBean : schemaBean.getTypes()) {
                            if (typeBean.follow("primaryResource") == null) continue;
                            String typeName = typeBean.getName();
                            final Class listRestBean = (Class)classesByName.get(packagePrefix + typeName + "ListRestBean");
                            Class restBean = (Class)classesByName.get(packagePrefix + typeName + "RestBean");
                            Class restReferenceBean = (Class)classesByName.get(packagePrefix + typeName + "ReferenceRestBean");
                            if (listRestBean == null || restBean == null || restReferenceBean == null) {
                                LOG.warn("could not find all required xml beans for type {} of schema {}", (Object)typeName, (Object)schemaBean.getName());
                                for (Listener listener : listeners) {
                                    listener.onMissingBeanClass(typeName, listRestBean, restBean, restReferenceBean);
                                }
                                continue;
                            }
                            final DefaultDaoImpl dao = new DefaultDaoImpl(listRestBean, restBean, restReferenceBean);
                            Initializer initializer = new Initializer(){
                                private boolean isInitialized = false;

                                @Override
                                public void init() throws ClientException {
                                    Object primaryResource = SchemaBeanDaoFactory.this.serviceFactory.createClient((Object)typeBean).follow("primaryResource").execute(listRestBean);
                                    dao.setPrimaryResource(primaryResource);
                                    this.isInitialized = true;
                                }

                                @Override
                                public boolean isInitialized() {
                                    return this.isInitialized;
                                }
                            };
                            dao.setInitializer(initializer);
                            dao.setServiceFactory(SchemaBeanDaoFactory.this.serviceFactory);
                            SchemaBeanDaoFactory.this.daosByTypeName.put(typeName, dao);
                            SchemaBeanDaoFactory.this.daosByRestBeanType.put(restBean, dao);
                            for (Listener listener : listeners) {
                                listener.onDaoCreated(dao, typeName);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            }
        };
        Future<?> initFutureTmp = this.initExecutor.submit(initRunnable);
        this.initFuture = initFutureTmp;
        return initFutureTmp;
    }

    public void destroy() {
        if (!this.initExecutor.isShutdown()) {
            LOG.info("shutting down init executor");
            this.initExecutor.shutdownNow();
        }
    }

    public void joinAndKeepExecutorServiceAlive() {
        this.join(false);
    }

    public void join() {
        this.join(true);
    }

    private void join(boolean destroyOnJoin) {
        try {
            if (this.finishedInitFuture != this.initFuture && this.initFuture != null) {
                try {
                    LOG.info("waiting for initialization to finish");
                    this.initFuture.get();
                    this.finishedInitFuture = this.initFuture;
                    LOG.info("initialization finished");
                }
                catch (InterruptedException ex) {
                    LOG.warn("initialization was aborted");
                }
                catch (ExecutionException ex) {
                    LOG.error("initialization failed", (Throwable)ex);
                }
            }
        }
        finally {
            if (destroyOnJoin) {
                this.destroy();
            }
        }
    }

    public DefaultDao getDaoForRestBeanType(final Class<?> restBeanType) {
        if (restBeanType == null) {
            throw new IllegalArgumentException("missing restBeanType argument");
        }
        return new LazyDefaultDao(){

            @Override
            protected DefaultDao waitForRealDao() {
                SchemaBeanDaoFactory.this.join();
                DefaultDao dao = (DefaultDao)SchemaBeanDaoFactory.this.daosByRestBeanType.get(restBeanType);
                if (dao == null) {
                    throw new IllegalStateException("could not find a DAO for the restBeanType: " + restBeanType);
                }
                return dao;
            }
        };
    }

    public void setServiceFactoryListeners(List list) {
        list.add(this);
    }

    public void setServiceFactory(ServiceFactory serviceFactory) {
        this.serviceFactory = serviceFactory;
    }

    public void setMessageClassProvider(JAXBMessageClassProvider messageClassProvider) {
        this.messageClassProvider = messageClassProvider;
    }

    public static interface Listener {
        public void onSchemaLoaded(SchemaBean var1);

        public void onDaoCreated(DefaultDao var1, String var2);

        public void onMissingBeanClass(String var1, Class<?> var2, Class<?> var3, Class<?> var4);
    }
}

