/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.common.service.client.dao;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.bndly.common.service.client.dao.DefaultDao;
import org.bndly.common.service.client.dao.Initializer;
import org.bndly.common.service.validation.FunctionReferenceRestBean;
import org.bndly.common.service.validation.RuleFunctionReferenceRestBean;
import org.bndly.common.service.validation.RuleFunctionRestBean;
import org.bndly.common.service.validation.RuleSetRestBean;
import org.bndly.common.service.validation.RulesRestBean;
import org.bndly.common.service.validation.interpreter.FunctionExecutionException;
import org.bndly.common.service.validation.interpreter.FunctionExecutor;
import org.bndly.common.service.validation.interpreter.MandatoryFieldFinder;
import org.bndly.rest.client.api.HATEOASClient;
import org.bndly.rest.client.api.RestBeanValidationException;
import org.bndly.rest.client.api.ServiceFactory;
import org.bndly.rest.client.api.ValidationResult;
import org.bndly.rest.client.api.ValidationRuleDescription;
import org.bndly.rest.client.exception.ClientException;
import org.bndly.rest.client.exception.MissingLinkClientException;
import org.bndly.rest.client.exception.UnknownResourceClientException;
import org.bndly.rest.client.exception.UnmanagedClientException;
import org.bndly.rest.common.beans.ListRestBean;
import org.bndly.rest.common.beans.PaginationRestBean;
import org.bndly.rest.common.beans.RestBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDaoImpl
implements DefaultDao {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDaoImpl.class);
    private ServiceFactory serviceFactory;
    private Object primaryResource;
    private final Class<?> listType;
    private final Class<?> restBeanType;
    private final Class<?> restBeanReferenceType;
    private Initializer initializer;
    private RulesRestBean cachedRules;
    private boolean didLookForRules;

    public DefaultDaoImpl(Class<?> listType, Class<?> restBeanType, Class<?> restBeanReferenceType) {
        this.listType = listType;
        this.restBeanType = restBeanType;
        this.restBeanReferenceType = restBeanReferenceType;
    }

    public void setInitializer(Initializer initializer) {
        this.initializer = initializer;
    }

    public HATEOASClient getPrimaryResourceClient() throws ClientException {
        if (this.initializer == null) {
            throw new IllegalStateException("missing initializer");
        }
        if (!this.initializer.isInitialized()) {
            this.initializer.init();
        }
        return this.createClient(this.primaryResource);
    }

    private HATEOASClient createClient(Object object) {
        return this.serviceFactory.createClient(object);
    }

    public Class getListType() {
        return this.listType;
    }

    public Object listAll() throws ClientException {
        Object tmp = this.getPrimaryResourceClient().read().execute();
        HATEOASClient tmpClient = this.createClient(tmp);
        try {
            while (true) {
                Object nextPage = tmpClient.next().execute();
                if (ListRestBean.class.isInstance(tmp) && ListRestBean.class.isInstance(nextPage)) {
                    ListRestBean t = (ListRestBean)tmp;
                    ListRestBean n = (ListRestBean)nextPage;
                    ArrayList i = t.getItems();
                    if (i == null) {
                        i = new ArrayList();
                        t.setItems(i);
                    }
                    if (n.getItems() != null) {
                        i.addAll(n.getItems());
                    }
                }
                tmpClient = this.createClient(nextPage);
            }
        }
        catch (MissingLinkClientException missingLinkClientException) {
            return tmp;
        }
    }

    public Collection listAllAsCollection() throws ClientException {
        Object tmp = this.listAll();
        return this.getItemsOfListRestBean(tmp);
    }

    public Object findAllLike(Object prototype) throws ClientException {
        return this.getPrimaryResourceClient().follow("findAll").execute(prototype);
    }

    public Object readNextPage(Object currentPage) throws ClientException {
        return this.createClient(currentPage).next().execute();
    }

    public Object readPreviousPage(Object currentPage) throws ClientException {
        return this.createClient(currentPage).previous().execute();
    }

    public long getTotalCount() throws ClientException {
        PaginationRestBean p;
        Object tmp = this.getPrimaryResourceClient().read().execute();
        if (ListRestBean.class.isInstance(tmp) && (p = ((ListRestBean)tmp).getPage()) != null && p.getTotalRecords() != null) {
            return p.getTotalRecords();
        }
        return -1L;
    }

    public Object findLocation(Object entity) throws ClientException {
        String location = (String)this.getPrimaryResourceClient().follow("find").preventRedirect().execute(entity, String.class);
        if (location == null) {
            return null;
        }
        this.setSelfLinkInRestBean(entity, location);
        return entity;
    }

    public Object find(Object entity) throws ClientException {
        return this.getPrimaryResourceClient().follow("find").execute(entity, entity.getClass());
    }

    public Object findWithLocale(Object entity, String locale) throws ClientException {
        return this.getPrimaryResourceClient().acceptLanguage(locale).follow("find").execute(entity, entity.getClass());
    }

    public Collection findAllLikeAsCollection(Object entity) throws ClientException {
        Object tmp = this.findAllLike(entity);
        return this.getItemsOfListRestBean(tmp);
    }

    public void print(Object entity, OutputStream os) throws ClientException {
        this.createClient(entity).accept("application/pdf").follow("print").execute(os);
    }

    public Object create(Object entity) throws ClientException {
        ValidationResult validationResult = this.validate(entity);
        if (validationResult.didFail()) {
            throw new RestBeanValidationException("validation failed. " + validationResult.getFailedRules());
        }
        return this.getPrimaryResourceClient().create().execute(entity);
    }

    public Object createLocation(Object entity) throws ClientException {
        ValidationResult validationResult = this.validate(entity);
        if (validationResult.didFail()) {
            throw new RestBeanValidationException("validation failed. " + validationResult.getFailedRules());
        }
        String location = (String)this.getPrimaryResourceClient().create().preventRedirect().execute(entity, String.class);
        if (location == null) {
            return null;
        }
        this.setSelfLinkInRestBean(entity, location);
        return entity;
    }

    public Object readFromUrl(String url) throws ClientException {
        try {
            Object bean = this.restBeanType.newInstance();
            this.setSelfLinkInRestBean(bean, url);
            return this.read(bean);
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new ClientException("could not instantiate type " + this.restBeanType.getSimpleName() + " to read it from url " + url, (Throwable)ex);
        }
    }

    public Object read(Object entity) throws ClientException {
        return this.createClient(entity).read().execute();
    }

    public Object update(Object entity) throws ClientException {
        ValidationResult validationResult = this.validate(entity);
        if (validationResult.didFail()) {
            throw new RestBeanValidationException("validation failed. " + validationResult.getFailedRules());
        }
        this.createClient(entity).update().execute(entity);
        return this.createClient(entity).read().execute();
    }

    public Object updateLocation(Object entity) throws ClientException {
        ValidationResult validationResult = this.validate(entity);
        if (validationResult.didFail()) {
            throw new RestBeanValidationException("validation failed. " + validationResult.getFailedRules());
        }
        this.createClient(entity).update().execute(entity);
        return entity;
    }

    public boolean delete(Object entity) throws ClientException {
        Object result = this.createClient(entity).delete().execute();
        return result == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ValidationResult validate(Object bean) throws ClientException {
        ValidationResult result = new ValidationResult();
        result.setValidatedBean(bean);
        if (bean == null) return result;
        try {
            if (this.cachedRules == null && !this.didLookForRules) {
                this.didLookForRules = true;
                try {
                    Iterator r = (RuleSetRestBean)this.getPrimaryResourceClient().follow("rules").execute(RuleSetRestBean.class);
                    if (r != null) {
                        this.cachedRules = r.getRules();
                    }
                }
                catch (UnmanagedClientException r) {
                    // empty catch block
                }
            }
            if (this.cachedRules == null) return result;
            for (RuleFunctionReferenceRestBean ruleFunctionReferenceRestBean : this.cachedRules) {
                if (!RuleFunctionRestBean.class.isInstance(ruleFunctionReferenceRestBean)) continue;
                RuleFunctionRestBean ruleFunctionRestBean = (RuleFunctionRestBean)ruleFunctionReferenceRestBean;
                FunctionExecutor executor = new FunctionExecutor(bean);
                try {
                    Boolean ruleSucceeded = (Boolean)executor.evaluate((FunctionReferenceRestBean)ruleFunctionRestBean);
                    ValidationRuleDescription description = new ValidationRuleDescription();
                    description.setAffectedPropertyName(ruleFunctionRestBean.getField());
                    description.setOriginalRule((Object)ruleFunctionRestBean);
                    description.setRuleName(ruleFunctionRestBean.getName());
                    if (ruleSucceeded.booleanValue()) {
                        result.addSucceededRule(description);
                        continue;
                    }
                    result.addFailedRule(description);
                }
                catch (Exception e) {
                    throw new FunctionExecutionException("could not execute rule function " + ruleFunctionRestBean.getName() + " for field " + ruleFunctionRestBean.getField(), e);
                    return result;
                }
            }
        }
        catch (UnknownResourceClientException e) {
            LOG.info(e.getMessage());
            return result;
        }
        catch (MissingLinkClientException e) {
            LOG.info(e.getMessage());
            return result;
        }
        finally {
            this.didLookForRules = true;
        }
    }

    public List listMandatoryFields() throws ClientException {
        try {
            RulesRestBean r = (RulesRestBean)this.getPrimaryResourceClient().follow("rules").execute(RulesRestBean.class);
            ArrayList<RuleFunctionRestBean> rules = new ArrayList<RuleFunctionRestBean>();
            for (RuleFunctionReferenceRestBean ruleFunctionReferenceRestBean : r) {
                rules.add((RuleFunctionRestBean)ruleFunctionReferenceRestBean);
            }
            MandatoryFieldFinder finder = new MandatoryFieldFinder();
            return finder.findMandatoryFields(rules, this.restBeanType);
        }
        catch (MissingLinkClientException e) {
            return null;
        }
    }

    public Class getBeanType() {
        return this.restBeanType;
    }

    public void setServiceFactory(ServiceFactory serviceFactory) {
        this.serviceFactory = serviceFactory;
    }

    public void setPrimaryResource(Object primaryResource) {
        this.primaryResource = primaryResource;
    }

    private Collection getItemsOfListRestBean(Object tmp) {
        if (ListRestBean.class.isInstance(tmp)) {
            return ((ListRestBean)tmp).getItems();
        }
        return null;
    }

    private void setSelfLinkInRestBean(Object entity, String location) {
        if (RestBean.class.isInstance(entity)) {
            ((RestBean)entity).setLink("self", location, "GET");
        }
    }

    public Object search(Object searchDescription) throws ClientException {
        return this.getPrimaryResourceClient().follow("search").execute(searchDescription, this.listType);
    }

    public Object getSearchParameters() {
        return null;
    }
}

