/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.testfixture.test.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import org.bndly.common.data.io.IOUtils;
import org.bndly.common.json.model.JSArray;
import org.bndly.common.json.model.JSMember;
import org.bndly.common.json.model.JSObject;
import org.bndly.common.json.model.JSValue;
import org.bndly.common.json.parsing.JSONParser;
import org.bndly.rest.beans.testfixture.TestFixtureRestBean;
import org.bndly.testfixture.client.TestFixtureClient;
import org.bndly.testfixture.test.api.CleanFixture;
import org.bndly.testfixture.test.api.Fixture;
import org.bndly.testfixture.test.api.FixtureSetupException;
import org.bndly.testfixture.test.impl.AbstractTestFixtureSupport;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.TestException;

public class TestFixtureExecutionListener
implements ITestListener {
    public static final TestFixtureClient testFixtureClient = new TestFixtureClient();
    boolean firstTestInClass = true;

    public static TestFixtureRestBean collectActiveTestFixtureFromServer(TestFixtureClient testFixtureResourceProxy, String schemaName) {
        try {
            TestFixtureRestBean currentlyActiveTestFixtureRestBean = testFixtureResourceProxy.get(schemaName);
            return currentlyActiveTestFixtureRestBean;
        }
        catch (Exception e) {
            throw new TestException((Throwable)e);
        }
    }

    private static JSObject getDataSetFromTestFixture(TestFixtureClient testFixtureResourceProxy, TestFixtureRestBean testFixtureRestBean) {
        Assert.assertNotNull((Object)testFixtureRestBean);
        Assert.assertNotNull((Object)testFixtureRestBean.getDataSetContent());
        try {
            return (JSObject)new JSONParser().parse((Reader)new StringReader(testFixtureRestBean.getDataSetContent()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void assertEmptyTables(TestFixtureClient testFixtureResourceProxy, String schemaName, String ... typesToEmpty) {
        Assert.assertNotNull((Object)schemaName);
        TestFixtureRestBean relevantTestFixtureSlice = TestFixtureExecutionListener.collectActiveTestFixtureFromServer(testFixtureResourceProxy, schemaName);
        JSObject dataSet = TestFixtureExecutionListener.getDataSetFromTestFixture(testFixtureResourceProxy, relevantTestFixtureSlice);
        if (dataSet.getMembers() != null) {
            for (JSMember jSMember : dataSet.getMembers()) {
                JSArray itemsArray;
                if (!"items".equals(jSMember.getName().getValue()) || (itemsArray = (JSArray)jSMember.getValue()) == null) continue;
                for (JSValue jSValue : itemsArray) {
                    JSObject typeElement = (JSObject)jSValue;
                    if (typeElement.getMembers() == null) continue;
                    String type = typeElement.getMemberStringValue("type");
                    boolean shouldBeCounted = false;
                    if (typesToEmpty == null || typesToEmpty.length == 0) {
                        shouldBeCounted = true;
                    } else {
                        for (String typesToEmpty1 : typesToEmpty) {
                            if (!typesToEmpty1.equals(type)) continue;
                            shouldBeCounted = true;
                            break;
                        }
                    }
                    if (!shouldBeCounted) continue;
                    for (JSMember jSMember1 : typeElement.getMembers()) {
                        JSArray entries;
                        if (!"entries".equals(jSMember1.getName().getValue()) || (entries = (JSArray)jSMember1.getValue()).getItems() == null || entries.getItems().isEmpty()) continue;
                        Assert.fail((String)"tables were not empty");
                    }
                }
            }
        }
    }

    public void onTestStart(ITestResult itr) {
        ITestNGMethod testMethod = itr.getMethod();
        try {
            Fixture annotation;
            Class testclass = testMethod.getRealClass();
            Method javaMethod = testclass.getMethod(testMethod.getMethodName(), new Class[0]);
            CleanFixture cf = testclass.getAnnotation(CleanFixture.class);
            if (cf != null) {
                this.deployFixture(cf.value(), cf.schema(), "clean", testclass, testMethod);
            }
            if ((annotation = javaMethod.getAnnotation(Fixture.class)) != null) {
                this.deployFixture(annotation.value(), annotation.schema(), annotation.description(), testclass, testMethod);
            }
        }
        catch (FixtureSetupException ex) {
            throw new IllegalStateException("failed to install a fixture", ex);
        }
        catch (NoSuchMethodException | SecurityException ex) {
            throw new IllegalStateException("could not find test method in testclass");
        }
    }

    private void deployFixture(String dataLocation, String schema, String purpose, Class testclass, ITestNGMethod testMethod) throws FixtureSetupException {
        block19: {
            TestFixtureRestBean tf = new TestFixtureRestBean();
            tf.setSchemaName(schema);
            tf.setPurpose(purpose);
            tf.setName(dataLocation);
            tf.setOrigin(testclass.getSimpleName() + "." + testMethod.getMethodName());
            Path p = Paths.get(dataLocation, new String[0]);
            if (Files.isRegularFile(p, new LinkOption[0])) {
                try (InputStream is = Files.newInputStream(p, StandardOpenOption.READ);){
                    String content = IOUtils.readToString((InputStream)is, (String)"UTF-8");
                    tf.setDataSetContent(content);
                    testFixtureClient.update(tf);
                    break block19;
                }
                catch (IOException e) {
                    throw new FixtureSetupException("read data from fixture file " + dataLocation);
                }
            }
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(dataLocation);
            if (is == null) {
                throw new FixtureSetupException("could not find test fixture data at " + dataLocation);
            }
            try {
                String content = IOUtils.readToString((InputStream)is, (String)"UTF-8");
                tf.setDataSetContent(content);
                testFixtureClient.update(tf);
            }
            catch (IOException e) {
                throw new FixtureSetupException("read data from fixture file " + dataLocation);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void onTestSuccess(ITestResult itr) {
    }

    public void onTestFailure(ITestResult itr) {
    }

    public void onTestSkipped(ITestResult itr) {
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult itr) {
    }

    public void onStart(ITestContext itc) {
        ITestNGMethod[] tm;
        for (ITestNGMethod tm1 : tm = itc.getAllTestMethods()) {
            if (!AbstractTestFixtureSupport.class.isInstance(tm1.getInstance())) continue;
            ((AbstractTestFixtureSupport)tm1.getInstance()).setTestFixtureClient(testFixtureClient);
        }
    }

    public void onFinish(ITestContext itc) {
    }
}

