/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.testfixture.client;

import org.bndly.rest.beans.testfixture.TestFixtureDumpRestBean;
import org.bndly.rest.beans.testfixture.TestFixtureRestBean;
import org.bndly.rest.beans.testfixture.TestFixtureStatusRestBean;
import org.bndly.rest.client.api.HATEOASClient;
import org.bndly.rest.client.api.ServiceFactory;
import org.bndly.rest.client.exception.ClientException;
import org.bndly.testfixture.test.api.FixtureSetupException;

public class TestFixtureClient {
    private ServiceFactory serviceFactory;
    private HATEOASClient<TestFixtureStatusRestBean> client;

    public TestFixtureRestBean get(String schemaName) throws FixtureSetupException {
        TestFixtureDumpRestBean dumpDesc = new TestFixtureDumpRestBean();
        dumpDesc.setSchemaName(schemaName);
        try {
            TestFixtureRestBean dumpedFixture = (TestFixtureRestBean)this.client.follow("dump").execute((Object)dumpDesc, TestFixtureRestBean.class);
            return dumpedFixture;
        }
        catch (ClientException e) {
            throw new FixtureSetupException("failed to dump fixture for schema " + schemaName, e);
        }
    }

    public void update(TestFixtureRestBean testFixtureRestBean) throws FixtureSetupException {
        try {
            this.client.update().execute((Object)testFixtureRestBean);
        }
        catch (ClientException e) {
            throw new FixtureSetupException("failed to install fixture for schema " + testFixtureRestBean.getSchemaName(), e);
        }
    }

    public void init() throws FixtureSetupException {
        try {
            this.client = this.serviceFactory.getServiceClient("testFixtures", TestFixtureStatusRestBean.class);
        }
        catch (ClientException e) {
            throw new FixtureSetupException("failed to init test fixture client", e);
        }
    }

    public void setServiceFactory(ServiceFactory serviceFactory) {
        this.serviceFactory = serviceFactory;
    }
}

