/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bar;

import java.nio.file.Path;
import java.util.Objects;
import org.bonitasoft.bonita2bar.BarBuilder;
import org.bonitasoft.bonita2bar.ClasspathResolver;
import org.bonitasoft.bonita2bar.ConnectorImplementationRegistry;
import org.bonitasoft.bonita2bar.ProcessRegistry;
import org.bonitasoft.bonita2bar.SourcePathProvider;
import org.bonitasoft.bonita2bar.actor.ActorMappingArtifactProvider;
import org.bonitasoft.bonita2bar.classpath.ConnectorImplementationArtifactProvider;
import org.bonitasoft.bonita2bar.classpath.CustomGroovyArtifactProvider;
import org.bonitasoft.bonita2bar.classpath.JarArtifactProvider;
import org.bonitasoft.bonita2bar.configuration.ParameterArtifactProvider;
import org.bonitasoft.bonita2bar.configuration.model.ParametersConfiguration;
import org.bonitasoft.bonita2bar.form.FormBuilder;
import org.bonitasoft.bonita2bar.form.FormMappingArtifactProvider;
import org.bonitasoft.bonita2bar.process.ProcessDefinitionArtifactProvider;
import org.bonitasoft.bonita2bar.resources.AdditionalResourcesArtifactProvider;
import org.bonitasoft.bonita2bar.resources.BPMN2ArtifactProvider;
import org.bonitasoft.bonita2bar.resources.DocumentArtifactProvider;

public class BarBuilderFactory {
    private BarBuilderFactory() {
    }

    public static BarBuilder create(BuildConfig config) {
        ParametersConfiguration parametersConfiguration = new ParametersConfiguration();
        SourcePathProvider sourceProvider = config.getSourcePathProvider();
        ProcessRegistry processRegistry = config.getProcessRegistry();
        ConnectorImplementationRegistry implementationRegistry = config.getConnectorImplementationRegistry();
        ClasspathResolver classpathResolver = config.getClasspathResolver();
        Path workingDirectory = config.getWorkingDirectory();
        BarBuilder barBuilder = new BarBuilder(processRegistry, sourceProvider.getLocalConfiguration(), parametersConfiguration, workingDirectory);
        barBuilder.register(new ParameterArtifactProvider(parametersConfiguration, config.includeParameters()));
        barBuilder.register(new ActorMappingArtifactProvider());
        barBuilder.register(new ProcessDefinitionArtifactProvider(config.getProcessRegistry()));
        barBuilder.register(new JarArtifactProvider(classpathResolver));
        barBuilder.register(new FormMappingArtifactProvider(sourceProvider.getForms(), config.getFormBuilder(), config.allowEmptyFormMapping()));
        barBuilder.register(new BPMN2ArtifactProvider(processRegistry, workingDirectory));
        barBuilder.register(new DocumentArtifactProvider(sourceProvider.getAttachments()));
        barBuilder.register(new CustomGroovyArtifactProvider(sourceProvider.getGroovySource(), classpathResolver, workingDirectory));
        barBuilder.register(new ConnectorImplementationArtifactProvider(classpathResolver, implementationRegistry, "CONNECTOR"));
        barBuilder.register(new ConnectorImplementationArtifactProvider(classpathResolver, implementationRegistry, "ACTOR_FILTER"));
        barBuilder.register(new AdditionalResourcesArtifactProvider(sourceProvider.getResources()));
        return barBuilder;
    }

    public static class BuildConfig {
        private boolean allowEmptyFormMapping;
        private boolean includeParameters;
        private Path workingDirectory;
        private ConnectorImplementationRegistry connectorImplementationRegistry;
        private FormBuilder formBuilder;
        private ProcessRegistry processRegistry;
        private SourcePathProvider sourcePathProvider;
        private ClasspathResolver classpathResolver;

        private BuildConfig(BuildConfigBuilder builder) {
            this.allowEmptyFormMapping = builder.allowEmptyFormMapping;
            this.includeParameters = builder.includeParameters;
            this.workingDirectory = builder.workingDirectory;
            this.connectorImplementationRegistry = builder.connectorImplementationRegistry;
            this.formBuilder = builder.formBuilder;
            this.processRegistry = builder.processRegistry;
            this.sourcePathProvider = builder.sourcePathProvider;
            this.classpathResolver = builder.classpathResolver;
        }

        public boolean includeParameters() {
            return this.includeParameters;
        }

        public boolean allowEmptyFormMapping() {
            return this.allowEmptyFormMapping;
        }

        public Path getWorkingDirectory() {
            Objects.requireNonNull(this.workingDirectory, "No workingDirectory configured.");
            return this.workingDirectory;
        }

        public ConnectorImplementationRegistry getConnectorImplementationRegistry() {
            Objects.requireNonNull(this.connectorImplementationRegistry, "No ConnectorImplementationRegistry configured.");
            return this.connectorImplementationRegistry;
        }

        public FormBuilder getFormBuilder() {
            Objects.requireNonNull(this.formBuilder, "No FormBuilder configured.");
            return this.formBuilder;
        }

        public ProcessRegistry getProcessRegistry() {
            Objects.requireNonNull(this.processRegistry, "No ProcessRegistry configured.");
            return this.processRegistry;
        }

        public SourcePathProvider getSourcePathProvider() {
            Objects.requireNonNull(this.sourcePathProvider, "No SourcePathProvider configured.");
            return this.sourcePathProvider;
        }

        public ClasspathResolver getClasspathResolver() {
            Objects.requireNonNull(this.sourcePathProvider, "No ClasspathResolver configured.");
            return this.classpathResolver;
        }

        public static BuildConfigBuilder builder() {
            return new BuildConfigBuilder();
        }

        public static class BuildConfigBuilder {
            private boolean allowEmptyFormMapping = true;
            private boolean includeParameters = false;
            private Path workingDirectory;
            private ConnectorImplementationRegistry connectorImplementationRegistry;
            private FormBuilder formBuilder;
            private ProcessRegistry processRegistry;
            private SourcePathProvider sourcePathProvider;
            private ClasspathResolver classpathResolver;

            private BuildConfigBuilder() {
            }

            public BuildConfig build() {
                return new BuildConfig(this);
            }

            public BuildConfigBuilder allowEmptyFormMapping(boolean allowEmptyFormMapping) {
                this.allowEmptyFormMapping = allowEmptyFormMapping;
                return this;
            }

            public BuildConfigBuilder includeParameters(boolean includeParameters) {
                this.includeParameters = includeParameters;
                return this;
            }

            public BuildConfigBuilder workingDirectory(Path workingDirectory) {
                this.workingDirectory = workingDirectory;
                return this;
            }

            public BuildConfigBuilder formBuilder(FormBuilder formBuilder) {
                this.formBuilder = formBuilder;
                return this;
            }

            public BuildConfigBuilder connectorImplementationRegistry(ConnectorImplementationRegistry connectorImplementationRegistry) {
                this.connectorImplementationRegistry = connectorImplementationRegistry;
                return this;
            }

            public BuildConfigBuilder processRegistry(ProcessRegistry processRegistry) {
                this.processRegistry = processRegistry;
                return this;
            }

            public BuildConfigBuilder sourcePathProvider(SourcePathProvider sourcePathProvider) {
                this.sourcePathProvider = sourcePathProvider;
                return this;
            }

            public BuildConfigBuilder classpathResolver(ClasspathResolver classpathResolver) {
                this.classpathResolver = classpathResolver;
                return this;
            }
        }
    }
}

