/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bar;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.jar.JarFile;
import org.bonitasoft.bpm.connector.model.implementation.ConnectorImplementation;
import org.bonitasoft.bpm.connector.model.implementation.DocumentRoot;
import org.bonitasoft.bpm.connector.model.implementation.util.ConnectorImplementationResourceFactoryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ConnectorImplementationRegistry {
    public static final Logger LOGGER = LoggerFactory.getLogger(ConnectorImplementationRegistry.class);
    public static final ConnectorImplementationResourceFactoryImpl RESOURCE_FACTORY = new ConnectorImplementationResourceFactoryImpl();

    public Optional<ConnectorImplementation> find(String var1, String var2);

    public static ConnectorImplementationRegistry of(final List<ConnectorImplementationJar> implementations) {
        return new ConnectorImplementationRegistry(){

            @Override
            public Optional<ConnectorImplementation> find(String id, String version) {
                return implementations.stream().filter(impl -> Objects.equals(impl.getId(), id) && Objects.equals(impl.getVersion(), version)).map(this::loadImplementation).filter(Objects::nonNull).findFirst();
            }

            /*
             * Loose catch block
             */
            private ConnectorImplementation loadImplementation(ConnectorImplementationJar implementation) {
                try {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try {
                        ConnectorImplementation connectorImplementation;
                        InputStream is;
                        JarFile jar;
                        block18: {
                            block17: {
                                jar = new JarFile(implementation.getJarFile());
                                is = jar.getInputStream(jar.getEntry(implementation.getEntry()));
                                Resource resource = RESOURCE_FACTORY.createResource(null);
                                resource.load(is, Collections.emptyMap());
                                connectorImplementation = ((DocumentRoot)resource.getContents().get(0)).getConnectorImplementation();
                                if (is == null) break block17;
                                is.close();
                            }
                            if (jar == null) break block18;
                            jar.close();
                        }
                        return connectorImplementation;
                        {
                            catch (Throwable throwable2) {
                                try {
                                    if (is != null) {
                                        is.close();
                                    }
                                    throw throwable2;
                                }
                                catch (Throwable throwable3) {
                                    if (throwable == null) {
                                        throwable = throwable3;
                                    } else if (throwable != throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    if (jar != null) {
                                        jar.close();
                                    }
                                    throw throwable;
                                }
                            }
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Failed to parse connector implementation", (Throwable)e);
                    return null;
                }
            }
        };
    }

    public static class ConnectorImplementationJar {
        private final String id;
        private final String version;
        private final File jarFile;
        private final String entry;

        public static ConnectorImplementationJar of(String id, String version, File jarFile, String entry) {
            return new ConnectorImplementationJar(id, version, jarFile, entry);
        }

        private ConnectorImplementationJar(String id, String version, File jarFile, String entry) {
            this.id = id;
            this.version = version;
            this.jarFile = jarFile;
            this.entry = entry;
        }

        public String getId() {
            return this.id;
        }

        public String getVersion() {
            return this.version;
        }

        public File getJarFile() {
            return this.jarFile;
        }

        public String getEntry() {
            return this.entry;
        }

        public int hashCode() {
            return Objects.hash(this.entry, this.id, this.jarFile, this.version);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConnectorImplementationJar other = (ConnectorImplementationJar)obj;
            return Objects.equals(this.entry, other.entry) && Objects.equals(this.id, other.id) && Objects.equals(this.jarFile, other.jarFile) && Objects.equals(this.version, other.version);
        }
    }
}

