/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bar.classpath;

import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.bonitasoft.bonita2bar.BarArtifactProvider;
import org.bonitasoft.bonita2bar.BuildBarException;
import org.bonitasoft.bonita2bar.ClasspathResolver;
import org.bonitasoft.bonita2bar.classpath.JarBuilder;
import org.bonitasoft.bpm.model.configuration.Configuration;
import org.bonitasoft.bpm.model.configuration.Fragment;
import org.bonitasoft.bpm.model.process.Pool;
import org.bonitasoft.bpm.model.util.EnvironmentUtil;
import org.bonitasoft.bpm.model.util.FileUtil;
import org.bonitasoft.bpm.model.util.IModelSearch;
import org.bonitasoft.bpm.model.util.ModelSearch;
import org.bonitasoft.engine.bpm.bar.BarResource;
import org.bonitasoft.engine.bpm.bar.BusinessArchiveBuilder;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.ProcessingUnit;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SimpleMessage;
import org.eclipse.emf.ecore.EObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomGroovyArtifactProvider
implements BarArtifactProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomGroovyArtifactProvider.class);
    static final String GROOVYSCRIPT_JAR = "groovyscripts.jar";
    static final String GROOVY_SOURCE_FOLDER = "src-groovy";
    private IModelSearch modelSearch = new ModelSearch(Collections::emptyList);
    private ClasspathResolver classpathResolver;
    private Path workingDirectory;
    private Path groovySource;

    public CustomGroovyArtifactProvider(Path groovySource, ClasspathResolver classpathResolver, Path workingDirectory) {
        this.groovySource = groovySource;
        this.classpathResolver = classpathResolver;
        this.workingDirectory = workingDirectory;
    }

    @Override
    public void build(BusinessArchiveBuilder builder, Pool process, Configuration configuration) throws BuildBarException {
        if (configuration == null) {
            return;
        }
        LOGGER.info("Adding custom groovy scripts in classpath...");
        Set<File> filesToCompile = this.collectGroovySourceFile(this.groovySource, configuration);
        if (filesToCompile.isEmpty()) {
            LOGGER.info("No custom groovy script to compile found.");
            return;
        }
        Path targetClasses = this.workingDirectory.resolve("groovy-classes");
        if (Files.exists(targetClasses, new LinkOption[0])) {
            try {
                FileUtil.deleteDir((Path)targetClasses);
            }
            catch (IOException e) {
                throw new BuildBarException(String.format("Failed to delete folder %s", targetClasses), e);
            }
        }
        try {
            Files.createDirectories(targetClasses, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new BuildBarException(String.format("Failed to create folder %s", targetClasses), e);
        }
        try {
            this.compile(filesToCompile, targetClasses.toFile());
        }
        catch (IOException | CompilationFailedException e) {
            throw new BuildBarException(String.format("Failed to compile custom groovy files for %s (%s) with %s configuration", process.getName(), process.getVersion(), configuration.getName()), e);
        }
        try {
            Path outputJarFile = this.workingDirectory.resolve(GROOVYSCRIPT_JAR);
            Files.deleteIfExists(outputJarFile);
            Path jarFile = JarBuilder.createJar(targetClasses.toFile(), outputJarFile);
            builder.addClasspathResource(new BarResource(GROOVYSCRIPT_JAR, Files.readAllBytes(jarFile)));
        }
        catch (IOException e) {
            throw new BuildBarException(String.format("Failed to add custom groovy jar in %s (%s) bar with %s configuration.", process.getName(), process.getVersion(), configuration.getName()), e);
        }
    }

    private void compile(Set<File> filesToCompile, File targetClasses) throws IOException, CompilationFailedException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (GroovyClassLoader classLoader = new GroovyClassLoader();){
            this.selectDependencies().forEach(arg_0 -> ((GroovyClassLoader)classLoader).addURL(arg_0));
            CompilerConfiguration configuration = new CompilerConfiguration();
            configuration.setTargetDirectory(targetClasses.getAbsolutePath());
            configuration.setSourceEncoding("utf-8");
            configuration.setTargetBytecode("11");
            CompilationUnit compileUnit = new CompilationUnit(configuration, null, classLoader);
            compileUnit.addSources(filesToCompile.toArray(new File[filesToCompile.size()]));
            if (EnvironmentUtil.isOSGi()) {
                compileUnit.addPhaseOperation(groovyClass -> {
                    String name = String.valueOf(groovyClass.getName().replace('.', File.separatorChar)) + ".class";
                    File path = new File(configuration.getTargetDirectory(), name);
                    File directory = path.getParentFile();
                    if (directory != null && !directory.exists()) {
                        directory.mkdirs();
                    }
                    try {
                        Throwable throwable = null;
                        Object var7_9 = null;
                        try (FileOutputStream stream = new FileOutputStream(path);){
                            byte[] bytes = groovyClass.getBytes();
                            stream.write(bytes, 0, bytes.length);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        compileUnit.getErrorCollector().addError((Message)new SimpleMessage(e.getMessage(), (ProcessingUnit)compileUnit));
                    }
                });
            }
            compileUnit.compile();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private List<URL> selectDependencies() throws IOException {
        return this.classpathResolver.listFiles().stream().map(File::toURI).map(uri -> {
            try {
                LOGGER.debug("{} added to compilation classpath", uri);
                return uri.toURL();
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException(e);
            }
        }).collect(Collectors.toList());
    }

    private Set<File> collectGroovySourceFile(Path groovySource, Configuration configuration) {
        return configuration.getProcessDependencies().stream().map(container -> this.modelSearch.getAllItemsOfType((EObject)container, Fragment.class)).flatMap(Collection::stream).filter(fragment -> Objects.equals(fragment.getType(), "GROOVY_SCRIPT") && fragment.isExported()).map(fragment -> {
            File groovySourceFile = groovySource.resolve(fragment.getValue()).toFile();
            if (groovySourceFile.exists()) {
                LOGGER.info("{} added to compilation classpath.", (Object)groovySource.relativize(groovySourceFile.toPath()));
                return groovySourceFile;
            }
            LOGGER.warn("{} not found with name in src-groovy", (Object)groovySourceFile.getName());
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }
}

