/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bar.classpath;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Collections;
import java.util.List;
import org.bonitasoft.bonita2bar.BarArtifactProvider;
import org.bonitasoft.bonita2bar.BuildBarException;
import org.bonitasoft.bonita2bar.ClasspathResolver;
import org.bonitasoft.bpm.model.configuration.Configuration;
import org.bonitasoft.bpm.model.configuration.Fragment;
import org.bonitasoft.bpm.model.configuration.FragmentContainer;
import org.bonitasoft.bpm.model.process.Pool;
import org.bonitasoft.bpm.model.util.IModelSearch;
import org.bonitasoft.bpm.model.util.ModelSearch;
import org.bonitasoft.engine.bpm.bar.BarResource;
import org.bonitasoft.engine.bpm.bar.BusinessArchiveBuilder;
import org.eclipse.emf.ecore.EObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarArtifactProvider
implements BarArtifactProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(JarArtifactProvider.class);
    private IModelSearch modelSearch = new ModelSearch(Collections::emptyList);
    private ClasspathResolver classpathResolver;

    public JarArtifactProvider(ClasspathResolver classpathResolver) {
        this.classpathResolver = classpathResolver;
    }

    @Override
    public void build(BusinessArchiveBuilder builder, Pool process, Configuration configuration) throws BuildBarException {
        if (configuration == null) {
            return;
        }
        for (FragmentContainer fc : configuration.getProcessDependencies()) {
            List fragments = this.modelSearch.getAllItemsOfType((EObject)fc, Fragment.class);
            for (Fragment fragment : fragments) {
                if (!fragment.getType().equals("JAR") || !fragment.isExported()) continue;
                try {
                    this.addJarToBusinessArchive(builder, fragment, configuration);
                }
                catch (IOException e) {
                    throw new BuildBarException(e);
                }
            }
        }
    }

    private void addJarToBusinessArchive(BusinessArchiveBuilder builder, Fragment fragment, Configuration configuration) throws BuildBarException, IOException {
        File jar = this.classpathResolver.findJarFile(fragment.getValue());
        if (jar == null || !jar.isFile()) {
            LOGGER.warn("{} dependency is missing but defined for {} environment", (Object)fragment.getValue(), (Object)configuration.getName());
            return;
        }
        try {
            LOGGER.info("Adding {} to classpath...", (Object)jar.getName());
            builder.addClasspathResource(new BarResource(jar.getName(), Files.readAllBytes(jar.toPath())));
        }
        catch (IOException e) {
            throw new BuildBarException(String.format("Unable to get content of the %s ", jar), e);
        }
    }
}

