/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bar.classpath;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

class JarBuilder {
    private JarBuilder() {
    }

    static Path createJar(File targetClasses, Path outputJarFile) throws IOException {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        Throwable throwable = null;
        Object var4_5 = null;
        try (JarOutputStream target = new JarOutputStream(Files.newOutputStream(outputJarFile, new OpenOption[0]), manifest);){
            File[] classes = targetClasses.listFiles();
            if (classes != null) {
                File[] fileArray = classes;
                int n = classes.length;
                int n2 = 0;
                while (n2 < n) {
                    File classFile = fileArray[n2];
                    JarBuilder.add(classFile, target, targetClasses);
                    ++n2;
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return outputJarFile;
    }

    private static void add(File source, JarOutputStream target, File targetClasses) throws IOException {
        String baseDir = String.valueOf(targetClasses.getPath()) + File.separatorChar;
        if (source.isDirectory()) {
            String name = source.getPath().replace("\\", "/").replace(baseDir.replace("\\", "/"), "");
            if (!name.isEmpty()) {
                if (!name.endsWith("/")) {
                    name = String.valueOf(name) + "/";
                }
                JarEntry entry = new JarEntry(name);
                entry.setTime(source.lastModified());
                target.putNextEntry(entry);
                target.closeEntry();
            }
            File[] fileArray = source.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File nestedFile = fileArray[n2];
                JarBuilder.add(nestedFile, target, targetClasses);
                ++n2;
            }
            return;
        }
        JarEntry entry = new JarEntry(source.getPath().replace("\\", "/").replace(baseDir.replace("\\", "/"), ""));
        entry.setTime(source.lastModified());
        target.putNextEntry(entry);
        Throwable throwable = null;
        Object var6_14 = null;
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(source));){
            int count;
            byte[] buffer = new byte[1024];
            while ((count = in.read(buffer)) != -1) {
                target.write(buffer, 0, count);
            }
            target.closeEntry();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

