/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bar.configuration;

import java.io.File;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.bonitasoft.bonita2bar.configuration.ParametersConfigurationMapper;
import org.bonitasoft.bonita2bar.configuration.model.ParametersConfiguration;

public class ConfigurationArchive {
    private File configurationFile;
    private ParametersConfigurationMapper mapper = new ParametersConfigurationMapper();

    public ConfigurationArchive(File configurationFile) {
        this.configurationFile = configurationFile;
    }

    public ParametersConfiguration loadParametersConfiguration() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ZipFile zipFile = new ZipFile(this.configurationFile);){
            ZipEntry entry = zipFile.getEntry("parameters.yml");
            if (entry == null) {
                throw new IOException(String.format("Invalid bonita configuration archive. No '%s' found.", "parameters.yml"));
            }
            return this.mapper.read(zipFile.getInputStream(entry));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

