/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bar.configuration;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipUtil
extends SimpleFileVisitor<Path>
implements AutoCloseable {
    public static final int BUFFER_SIZE = 4096;
    private Path source;
    private FileOutputStream fos;
    private ZipOutputStream zos;
    private Predicate<Path> targetFilter;

    public static void zip(Path source, Path target) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ZipUtil zippingVisitor = new ZipUtil(source, target);){
            Files.walkFileTree(source, zippingVisitor);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public ZipUtil(Path source, Path target) throws FileNotFoundException {
        this.source = source;
        this.fos = new FileOutputStream(target.toFile());
        this.zos = new ZipOutputStream(this.fos);
        this.targetFilter = target::equals;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        if (this.targetFilter.test(file)) {
            return FileVisitResult.CONTINUE;
        }
        if (!file.toFile().exists()) {
            throw new IOException("File " + file.toString() + " not found.");
        }
        Path zipEntryPath = this.source.relativize(file);
        byte[] buffer = new byte[4096];
        Throwable throwable = null;
        Object var6_7 = null;
        try (FileInputStream fis = new FileInputStream(file.toFile());){
            int length;
            this.zos.putNextEntry(new ZipEntry(ZipUtil.normalizePath(zipEntryPath)));
            while ((length = fis.read(buffer)) > 0) {
                this.zos.write(buffer, 0, length);
            }
            this.zos.closeEntry();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return FileVisitResult.CONTINUE;
    }

    public static String normalizePath(Path path) {
        return path.toString().replace("\\", "/");
    }

    @Override
    public void close() throws IOException {
        this.zos.close();
        this.fos.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Path unzip(File file, Path targetFolder) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            FileInputStream fis = new FileInputStream(file);
            try {
                try (ZipInputStream zis = new ZipInputStream(new BufferedInputStream(fis));){
                    ZipEntry entry;
                    while ((entry = zis.getNextEntry()) != null) {
                        ZipUtil.unzipEntry(targetFolder, zis, entry);
                    }
                }
                if (fis == null) return targetFolder;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (fis == null) throw throwable;
                fis.close();
                throw throwable;
            }
            fis.close();
            return targetFolder;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void unzipEntry(Path targetDir, ZipInputStream zis, ZipEntry entry) throws IOException {
        File target = targetDir.toFile().toPath().resolve(entry.getName()).toFile();
        if (entry.isDirectory()) {
            if (target.exists()) return;
            target.mkdirs();
            return;
        }
        if (!target.exists()) {
            target.getParentFile().mkdirs();
            if (!target.createNewFile()) {
                throw new IOException("Failed to create file " + target.getAbsolutePath());
            }
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            FileOutputStream fos = new FileOutputStream(target);
            try {
                try (BufferedOutputStream dest = new BufferedOutputStream(fos, 4096);){
                    int count;
                    byte[] data = new byte[4096];
                    while ((count = zis.read(data, 0, 4096)) != -1) {
                        dest.write(data, 0, count);
                    }
                    dest.flush();
                }
                if (fos == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (fos == null) throw throwable;
                fos.close();
                throw throwable;
            }
            fos.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }
}

