/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bar.configuration.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.bonitasoft.bonita2bar.configuration.model.Parameter;

public class ProcessConfiguration {
    private String name;
    private String version;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<Parameter> parameters = new ArrayList<Parameter>();

    public ProcessConfiguration() {
    }

    public ProcessConfiguration(String name, String version, List<Parameter> parameters) {
        this.name = name;
        this.version = version;
        this.parameters = parameters;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.parameters, this.version);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProcessConfiguration other = (ProcessConfiguration)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.parameters, other.parameters) && Objects.equals(this.version, other.version);
    }

    public static ProcessConfigurationBuilder builder() {
        return new ProcessConfigurationBuilder();
    }

    public static class ProcessConfigurationBuilder {
        private String name;
        private String version;
        private List<Parameter> parameters = new ArrayList<Parameter>();

        ProcessConfigurationBuilder() {
        }

        public ProcessConfigurationBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ProcessConfigurationBuilder version(String version) {
            this.version = version;
            return this;
        }

        public ProcessConfigurationBuilder parameters(List<Parameter> parameters) {
            this.parameters = parameters;
            return this;
        }

        public ProcessConfiguration build() {
            return new ProcessConfiguration(this.name, this.version, this.parameters);
        }
    }
}

