/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bar.form;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.bonitasoft.bonita2bar.form.CustomPageBarResourceBuilder;
import org.bonitasoft.bonita2bar.form.FormMappingException;
import org.bonitasoft.bonita2bar.form.InternalFormNotFoundException;
import org.bonitasoft.bonita2bar.form.PageUUIDResolver;
import org.bonitasoft.bonita2bar.form.URLNotDefinedException;
import org.bonitasoft.bpm.model.process.AbstractProcess;
import org.bonitasoft.bpm.model.process.Element;
import org.bonitasoft.bpm.model.process.FormMapping;
import org.bonitasoft.bpm.model.process.FormMappingType;
import org.bonitasoft.bpm.model.process.Pool;
import org.bonitasoft.bpm.model.process.ProcessPackage;
import org.bonitasoft.bpm.model.process.Task;
import org.bonitasoft.bpm.model.util.ModelSearch;
import org.bonitasoft.engine.bpm.bar.BusinessArchiveBuilder;
import org.bonitasoft.engine.bpm.bar.form.model.FormMappingDefinition;
import org.bonitasoft.engine.bpm.bar.form.model.FormMappingModel;
import org.bonitasoft.engine.form.FormMappingTarget;
import org.eclipse.emf.ecore.EObject;

public class FormMappingBarResourceProvider {
    private static final String CUSTOMPAGE_PREFIX = "custompage_";
    private static final String AUTOGENERATED_OVERVIEW_CUSTOM_PAGE = "custompage_caseoverview";
    private final CustomPageBarResourceBuilder customPageBarResourceBuilder;
    private ModelSearch modelSearch;
    private Path formsFolder;
    private boolean allowEmptyMapping;

    FormMappingBarResourceProvider(CustomPageBarResourceBuilder customPageBarResourceBuilder, Path formsFolder, boolean allowEmptyMapping) {
        this.customPageBarResourceBuilder = customPageBarResourceBuilder;
        this.formsFolder = formsFolder;
        this.allowEmptyMapping = allowEmptyMapping;
        this.modelSearch = new ModelSearch(Collections::emptyList);
    }

    void addResourcesForConfiguration(BusinessArchiveBuilder builder, AbstractProcess process) throws IOException, FormMappingException {
        Objects.requireNonNull(process != null);
        builder.setFormMappings(this.newFormMappingModel(builder, process));
    }

    FormMappingModel newFormMappingModel(BusinessArchiveBuilder builder, AbstractProcess process) throws IOException, FormMappingException {
        List allFormMappings = this.modelSearch.getAllItemsOfType((EObject)process, FormMapping.class);
        FormMappingModel formMappingModel = new FormMappingModel();
        for (FormMapping formMapping : allFormMappings) {
            this.addFormMapping(builder, formMappingModel, formMapping);
        }
        return formMappingModel;
    }

    private void addFormMapping(BusinessArchiveBuilder builder, FormMappingModel formMappingModel, FormMapping formMapping) throws IOException, FormMappingException {
        if (this.shouldAddFormMapping(formMapping)) {
            FormMappingDefinition mappingDefinition = this.newFormMappingDefinition(formMapping);
            formMappingModel.addFormMapping(mappingDefinition);
            if (mappingDefinition.getTarget() == FormMappingTarget.INTERNAL) {
                String formId = this.formId(formMapping);
                if (FormMappingBarResourceProvider.isNullOrEmpty(formId) && FormMappingBarResourceProvider.hasText(formMapping.getTargetForm().getContent())) {
                    throw new InternalFormNotFoundException(formMapping);
                }
                if (FormMappingBarResourceProvider.hasText(formId)) {
                    builder.addExternalResource(this.customPageBarResourceBuilder.newBarResource(mappingDefinition.getForm(), formId));
                }
            }
        }
    }

    private FormMappingDefinition newFormMappingDefinition(FormMapping formMapping) {
        return this.isTaskMapping(formMapping) ? new FormMappingDefinition(this.formValue(formMapping), this.formMappingType(formMapping), FormMappingTarget.valueOf((String)formMapping.getType().getName()), this.taskName(formMapping)) : new FormMappingDefinition(this.formValue(formMapping), this.formMappingType(formMapping), FormMappingTarget.valueOf((String)formMapping.getType().getName()));
    }

    private org.bonitasoft.engine.form.FormMappingType formMappingType(FormMapping formMapping) {
        return ProcessPackage.Literals.PAGE_FLOW__FORM_MAPPING.equals(formMapping.eContainingFeature()) ? this.mappingScope(formMapping) : org.bonitasoft.engine.form.FormMappingType.PROCESS_OVERVIEW;
    }

    private org.bonitasoft.engine.form.FormMappingType mappingScope(FormMapping formMapping) {
        return formMapping.eContainer() instanceof Pool ? org.bonitasoft.engine.form.FormMappingType.PROCESS_START : org.bonitasoft.engine.form.FormMappingType.TASK;
    }

    private String formValue(FormMapping formMapping) {
        switch (formMapping.getType()) {
            case URL: {
                return FormMappingBarResourceProvider.isNullOrEmpty(formMapping.getUrl()) ? null : formMapping.getUrl();
            }
            case INTERNAL: {
                return FormMappingBarResourceProvider.hasText(this.formName(formMapping)) ? this.toPageId(formMapping) : this.fallbackPageId(formMapping);
            }
        }
        throw new IllegalStateException(String.format("Unsupported FormMappingType: %s", formMapping.getType()));
    }

    private static boolean hasText(String value) {
        return value != null && !value.isBlank();
    }

    private static boolean isNullOrEmpty(String value) {
        return value == null || value.isEmpty();
    }

    private String fallbackPageId(FormMapping formMapping) {
        return this.formMappingType(formMapping) == org.bonitasoft.engine.form.FormMappingType.PROCESS_OVERVIEW ? AUTOGENERATED_OVERVIEW_CUSTOM_PAGE : null;
    }

    private String toPageId(FormMapping formMapping) {
        return String.format("%s%s", CUSTOMPAGE_PREFIX, this.formName(formMapping));
    }

    private String formName(FormMapping formMapping) {
        return formMapping.getTargetForm().getName();
    }

    private String formId(FormMapping formMapping) {
        if (formMapping.getType() != FormMappingType.INTERNAL) {
            throw new IllegalArgumentException("Only internal mapping has a form uuid");
        }
        return this.resolveUUID(formMapping.getTargetForm().getContent());
    }

    protected String resolveUUID(String uuid) {
        return new PageUUIDResolver(this.formsFolder.toFile()).resolveUUID(uuid);
    }

    private String taskName(FormMapping formMapping) {
        if (!(formMapping.eContainer() instanceof Element)) {
            throw new IllegalArgumentException();
        }
        return ((Element)formMapping.eContainer()).getName();
    }

    private boolean isTaskMapping(FormMapping formMapping) {
        return formMapping.eContainer() instanceof Task;
    }

    private boolean shouldAddFormMapping(FormMapping formMapping) throws FormMappingException {
        switch (formMapping.getType()) {
            case INTERNAL: {
                org.bonitasoft.engine.form.FormMappingType formMappingType = this.formMappingType(formMapping);
                if (formMappingType == org.bonitasoft.engine.form.FormMappingType.PROCESS_OVERVIEW) {
                    return true;
                }
                if (!this.allowEmptyMapping() && !formMapping.getTargetForm().hasName()) {
                    throw new InternalFormNotFoundException(formMapping);
                }
                return true;
            }
            case URL: {
                if (!this.allowEmptyMapping() && this.formMappingType(formMapping) != org.bonitasoft.engine.form.FormMappingType.PROCESS_OVERVIEW && FormMappingBarResourceProvider.isNullOrEmpty(formMapping.getUrl())) {
                    throw new URLNotDefinedException(formMapping);
                }
                return true;
            }
            case NONE: {
                return false;
            }
        }
        throw new IllegalStateException(String.format("Unsupported FormMappingType: %s", formMapping.getType()));
    }

    private boolean allowEmptyMapping() {
        return this.allowEmptyMapping;
    }
}

