/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bar.process;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bonitasoft.bonita2bar.ProcessRegistry;
import org.bonitasoft.bpm.connector.model.ConnectorModelRegistration;
import org.bonitasoft.bpm.model.process.MainProcess;
import org.bonitasoft.bpm.model.process.Pool;
import org.bonitasoft.bpm.model.process.util.migration.MigrationPolicy;
import org.bonitasoft.bpm.model.util.ModelLoader;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.notation.NotationPackage;

public class ProcessRegistryImpl
implements ProcessRegistry {
    private List<Pool> processes;
    private MigrationPolicy migrationPolicy;
    private List<Path> procFiles;

    public ProcessRegistryImpl(List<Path> procFiles, MigrationPolicy policy) {
        this.procFiles = procFiles;
        this.migrationPolicy = policy;
    }

    public ProcessRegistryImpl(Path diagramsFolder, MigrationPolicy policy) {
        this(ProcessRegistryImpl.listProceFiles(diagramsFolder), policy);
    }

    private static List<Path> listProceFiles(Path folder) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (Stream<Path> files = Files.walk(folder, new FileVisitOption[0]);){
                return files.filter(file -> file.getFileName().toString().endsWith(".proc")).collect(Collectors.toList());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public List<Pool> getProcesses() {
        if (this.processes == null) {
            this.processes = new ArrayList<Pool>();
            ModelLoader.Prerequisite[] prerequisiteArray = new ModelLoader.Prerequisite[1];
            prerequisiteArray[0] = ModelLoader.Prerequisite.fromRunnableWhenNotInOSGi(() -> ((NotationPackage)NotationPackage.eINSTANCE).getNsURI());
            ModelLoader modelLoader = ModelLoader.create().withPrerequisite(new ModelLoader.Prerequisite[]{ModelLoader.Prerequisite.fromRunnableWhenNotInOSGi((Runnable)ConnectorModelRegistration.REGISTER)}).withPrerequisite(prerequisiteArray).withPolicy(this.migrationPolicy);
            this.procFiles.stream().filter(file -> file.getFileName().toString().endsWith(".proc")).forEach(procFile -> {
                Resource resource = modelLoader.loadModel(URI.createFileURI((String)procFile.toAbsolutePath().toString()));
                MainProcess mainProcess = resource.getContents().stream().filter(MainProcess.class::isInstance).map(MainProcess.class::cast).findFirst().orElseThrow(() -> new IllegalStateException(String.format("No MainProcess found in file %s", procFile.toAbsolutePath())));
                mainProcess.getElements().stream().filter(Pool.class::isInstance).map(Pool.class::cast).forEach(this.processes::add);
            });
        }
        return this.processes;
    }

    @Override
    public Optional<Pool> getProcess(String name, String version) {
        return this.getProcesses().stream().filter(Pool.class::isInstance).map(Pool.class::cast).filter(process -> Objects.equals(process.getName(), name)).filter(process -> Objects.equals(process.getVersion(), version)).findFirst();
    }

    @Override
    public MigrationPolicy getMigrationPolicy() {
        return this.migrationPolicy;
    }
}

