/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bar.process.builder;

import java.util.Objects;
import org.bonitasoft.bonita2bar.process.builder.BuildProcessDefinitionException;
import org.bonitasoft.bonita2bar.process.builder.IEngineDefinitionBuilder;
import org.bonitasoft.bpm.model.process.Contract;
import org.bonitasoft.bpm.model.process.ContractConstraint;
import org.bonitasoft.bpm.model.process.ContractInput;
import org.bonitasoft.bpm.model.process.ContractInputType;
import org.bonitasoft.engine.bpm.contract.Type;
import org.bonitasoft.engine.bpm.process.impl.ContractDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.InputContainerDefinitionBuilder;
import org.eclipse.emf.ecore.EObject;

public abstract class ContractEngineDefinitionBuilder<T>
implements IEngineDefinitionBuilder<T> {
    protected T builder;

    @Override
    public void build(EObject element) throws BuildProcessDefinitionException {
        Objects.requireNonNull(this.builder);
        if (!(element instanceof Contract)) {
            throw new IllegalArgumentException();
        }
        Contract contract = (Contract)element;
        ContractDefinitionBuilder contractBuilder = this.addContract();
        for (ContractInput input : contract.getInputs()) {
            this.addInput(input, (InputContainerDefinitionBuilder)contractBuilder);
        }
        this.buildConstraints(contract, contractBuilder);
    }

    protected void buildConstraints(Contract contract, ContractDefinitionBuilder contractBuilder) {
        for (ContractConstraint constraint : contract.getConstraints()) {
            contractBuilder.addConstraint(constraint.getName(), constraint.getExpression(), constraint.getErrorMessage(), (String[])constraint.getInputNames().toArray((Object[])new String[constraint.getInputNames().size()]));
        }
    }

    protected abstract ContractDefinitionBuilder addContract();

    @Override
    public void setEngineBuilder(T engineBuilder) {
        this.builder = engineBuilder;
    }

    private void addChildInput(ContractInput input, InputContainerDefinitionBuilder contractInputDefinitionBuilder) {
        for (ContractInput child : input.getInputs()) {
            this.addInput(child, contractInputDefinitionBuilder);
        }
    }

    private void addInput(ContractInput input, InputContainerDefinitionBuilder contractInputDefinitionBuilder) {
        if (ContractInputType.COMPLEX == input.getType()) {
            this.addChildInput(input, (InputContainerDefinitionBuilder)contractInputDefinitionBuilder.addComplexInput(input.getName(), input.getDescription(), input.isMultiple()));
        } else if (Type.FILE == this.getInputType(input)) {
            contractInputDefinitionBuilder.addFileInput(input.getName(), input.getDescription(), input.isMultiple());
        } else {
            contractInputDefinitionBuilder.addInput(input.getName(), this.getInputType(input), input.getDescription(), input.isMultiple());
        }
    }

    private Type getInputType(ContractInput input) {
        return Type.valueOf((String)input.getType().getName());
    }

    @Override
    public boolean appliesTo(EObject context, EObject element) {
        return element instanceof Contract;
    }
}

