/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bar.process.builder;

import org.bonitasoft.bonita2bar.process.builder.ProcessBuilderException;
import org.bonitasoft.bonita2bar.process.expression.DecisionTableUtil;
import org.bonitasoft.bonita2bar.process.expression.EngineExpressionUtil;
import org.bonitasoft.bpm.model.expression.AbstractExpression;
import org.bonitasoft.bpm.model.expression.Expression;
import org.bonitasoft.bpm.model.process.ANDGateway;
import org.bonitasoft.bpm.model.process.BoundaryEvent;
import org.bonitasoft.bpm.model.process.CatchLinkEvent;
import org.bonitasoft.bpm.model.process.Connection;
import org.bonitasoft.bpm.model.process.SequenceFlow;
import org.bonitasoft.bpm.model.process.SequenceFlowConditionType;
import org.bonitasoft.bpm.model.process.SourceElement;
import org.bonitasoft.bpm.model.process.TargetElement;
import org.bonitasoft.bpm.model.process.ThrowLinkEvent;
import org.bonitasoft.bpm.model.process.util.ProcessSwitch;
import org.bonitasoft.engine.bpm.process.impl.FlowElementBuilder;
import org.bonitasoft.engine.expression.InvalidExpressionException;

public class EngineSequenceFlowBuilder
extends ProcessSwitch<SequenceFlow> {
    private final FlowElementBuilder builder;

    public EngineSequenceFlowBuilder(FlowElementBuilder processBuilder) {
        this.builder = processBuilder;
    }

    public SequenceFlow caseSequenceFlow(SequenceFlow sequenceFlow) {
        SourceElement source = sequenceFlow.getSource();
        TargetElement target = sequenceFlow.getTarget();
        if (source == null) {
            throw new ProcessBuilderException("Source of sequenceflow is null");
        }
        if (target == null) {
            throw new ProcessBuilderException("Target of sequenceflow is null");
        }
        String sourceId = source.getName();
        String targetId = target.getName();
        if (target instanceof ThrowLinkEvent || source instanceof CatchLinkEvent) {
            try {
                this.addLinkEvents(this.builder, sequenceFlow);
            }
            catch (InvalidExpressionException e) {
                throw new ProcessBuilderException(e);
            }
        } else if (!(source instanceof ANDGateway)) {
            this.addTransitionCondition(sequenceFlow, source, sourceId, targetId);
        } else {
            this.builder.addTransition(sourceId, targetId);
        }
        return sequenceFlow;
    }

    private void addTransitionCondition(SequenceFlow sequenceFlow, SourceElement source, String sourceId, String targetId) {
        SequenceFlowConditionType conditionType = sequenceFlow.getConditionType();
        Expression condition = sequenceFlow.getCondition();
        try {
            if (sequenceFlow.isIsDefault() && !(source instanceof BoundaryEvent)) {
                this.builder.addDefaultTransition(sourceId, targetId);
            } else if (conditionType == SequenceFlowConditionType.EXPRESSION && condition != null && condition.getContent() != null && !condition.getContent().isEmpty()) {
                org.bonitasoft.engine.expression.Expression conditionExpression = EngineExpressionUtil.createExpression((AbstractExpression)condition);
                if (conditionExpression == null) {
                    throw new IllegalArgumentException("Condition expression " + condition.getName() + " on SequenceFlow from " + sourceId + " to " + targetId + " is invalid");
                }
                this.builder.addTransition(sourceId, targetId, conditionExpression);
            } else if (conditionType == SequenceFlowConditionType.DECISION_TABLE) {
                this.builder.addTransition(sourceId, targetId, EngineExpressionUtil.createExpression((AbstractExpression)DecisionTableUtil.toGroovyScriptExpression(sequenceFlow.getDecisionTable())));
            } else {
                this.builder.addTransition(sourceId, targetId);
            }
        }
        catch (InvalidExpressionException e) {
            throw new ProcessBuilderException(e);
        }
    }

    protected void addLinkEvents(FlowElementBuilder builder, SequenceFlow sequenceFlow) throws InvalidExpressionException {
        if (sequenceFlow.getTarget() instanceof ThrowLinkEvent) {
            ThrowLinkEvent throwLink = (ThrowLinkEvent)sequenceFlow.getTarget();
            if (throwLink.getTo() != null) {
                CatchLinkEvent target = throwLink.getTo();
                for (Connection c : target.getOutgoing()) {
                    String sourceId = sequenceFlow.getSource().getName();
                    String targetId = c.getTarget().getName();
                    Expression transitionCondition = sequenceFlow.getCondition();
                    if (sequenceFlow.isIsDefault()) {
                        builder.addDefaultTransition(sourceId, targetId);
                        continue;
                    }
                    if (transitionCondition != null && transitionCondition.getContent() != null && !transitionCondition.getContent().isEmpty()) {
                        builder.addTransition(sourceId, targetId, EngineExpressionUtil.createExpression((AbstractExpression)transitionCondition));
                        continue;
                    }
                    builder.addTransition(sourceId, targetId);
                }
            } else {
                throw new ProcessBuilderException(String.format("The go to attribute of %s must be specified", throwLink.getName()));
            }
        }
    }
}

