/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bar.process.expression;

import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.bonitasoft.bpm.connector.model.definition.Output;
import org.bonitasoft.bpm.model.expression.Expression;
import org.bonitasoft.bpm.model.expression.ExpressionFactory;
import org.bonitasoft.bpm.model.parameter.Parameter;
import org.bonitasoft.bpm.model.process.BooleanType;
import org.bonitasoft.bpm.model.process.BusinessObjectData;
import org.bonitasoft.bpm.model.process.BusinessObjectType;
import org.bonitasoft.bpm.model.process.ContractInput;
import org.bonitasoft.bpm.model.process.ContractInputType;
import org.bonitasoft.bpm.model.process.Data;
import org.bonitasoft.bpm.model.process.DataType;
import org.bonitasoft.bpm.model.process.DateType;
import org.bonitasoft.bpm.model.process.DoubleType;
import org.bonitasoft.bpm.model.process.IntegerType;
import org.bonitasoft.bpm.model.process.JavaObjectData;
import org.bonitasoft.bpm.model.process.JavaType;
import org.bonitasoft.bpm.model.process.LongType;
import org.bonitasoft.bpm.model.process.MainProcess;
import org.bonitasoft.bpm.model.process.MultiInstantiable;
import org.bonitasoft.bpm.model.process.ProcessFactory;
import org.bonitasoft.bpm.model.process.SearchIndex;
import org.bonitasoft.bpm.model.process.StringType;
import org.bonitasoft.bpm.model.process.util.DataUtil;
import org.bonitasoft.engine.bpm.document.Document;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ExpressionHelper {
    protected static final String EMPTY_LIST_NAME = "Empty list";
    protected static final String EMPTY_LIST_CONTENT = "[]";

    private ExpressionHelper() {
    }

    public static Expression createConstantExpression(String content, String returnClassName) {
        Expression exp = ExpressionFactory.eINSTANCE.createExpression();
        exp.setType("TYPE_CONSTANT");
        exp.setName(content);
        exp.setContent(content);
        exp.setReturnType(returnClassName);
        return exp;
    }

    public static EObject createDependencyFromEObject(EObject dependency) {
        if (dependency instanceof Data) {
            return ExpressionHelper.createDataDependency(dependency);
        }
        if (dependency instanceof org.bonitasoft.bpm.model.process.Document) {
            return ExpressionHelper.createDocumentDependency(dependency);
        }
        if (dependency instanceof SearchIndex) {
            return ExpressionHelper.createSearchIndexDependency(dependency);
        }
        if (dependency instanceof ContractInput) {
            return ExpressionHelper.createContractInputDependency(dependency);
        }
        return EcoreUtil.copy((EObject)dependency);
    }

    private static EObject createContractInputDependency(EObject dependency) {
        ContractInput contractInputDependency = (ContractInput)EcoreUtil.copy((EObject)dependency);
        if (contractInputDependency.getType() == ContractInputType.COMPLEX) {
            contractInputDependency.getInputs().clear();
        }
        contractInputDependency.setDataReference(null);
        return contractInputDependency;
    }

    private static EObject createSearchIndexDependency(EObject dependency) {
        SearchIndex searchIndexDependency = (SearchIndex)ProcessFactory.eINSTANCE.create(dependency.eClass());
        Expression name = ((SearchIndex)dependency).getName();
        if (name != null) {
            Expression nameExpression = (Expression)EcoreUtil.copy((EObject)name);
            nameExpression.getReferencedElements().clear();
            searchIndexDependency.setName(nameExpression);
        }
        return searchIndexDependency;
    }

    private static EObject createDocumentDependency(EObject dependency) {
        org.bonitasoft.bpm.model.process.Document documentDependency = (org.bonitasoft.bpm.model.process.Document)ProcessFactory.eINSTANCE.create(dependency.eClass());
        documentDependency.setName(((org.bonitasoft.bpm.model.process.Document)dependency).getName());
        documentDependency.setMultiple(((org.bonitasoft.bpm.model.process.Document)dependency).isMultiple());
        return documentDependency;
    }

    private static EObject createDataDependency(EObject dependency) {
        Data dataDependency = (Data)EcoreUtil.copy((EObject)dependency);
        dataDependency.setDefaultValue(null);
        return dataDependency;
    }

    private static Expression createVariableExpression(Data data) {
        Expression expression = ExpressionFactory.eINSTANCE.createExpression();
        expression.setType("TYPE_VARIABLE");
        expression.setReturnType(DataUtil.getTechnicalTypeFor((Data)data));
        expression.setName(data.getName());
        expression.setContent(data.getName());
        expression.getReferencedElements().add((Object)ExpressionHelper.createDependencyFromEObject((EObject)data));
        return expression;
    }

    public static Expression createExpressionFromEObject(EObject element) {
        if (element instanceof Data) {
            return ExpressionHelper.createVariableExpression((Data)element);
        }
        if (element instanceof Output) {
            return ExpressionHelper.createConnectorOutputExpression((Output)element);
        }
        if (element instanceof Parameter) {
            return ExpressionHelper.createParameterExpression((Parameter)element);
        }
        if (element instanceof Expression) {
            return (Expression)EcoreUtil.copy((EObject)element);
        }
        if (element instanceof org.bonitasoft.bpm.model.process.Document) {
            return ExpressionHelper.createDocumentExpressionWithDependency((org.bonitasoft.bpm.model.process.Document)element);
        }
        if (element instanceof ContractInput) {
            return ExpressionHelper.createContractInputExpression((ContractInput)element);
        }
        throw new IllegalArgumentException("element argument is not supported: " + element);
    }

    private static Expression createContractInputExpression(ContractInput input) {
        Expression exp = ExpressionFactory.eINSTANCE.createExpression();
        exp.setType("TYPE_CONTRACT_INPUT");
        exp.setContent(input.getName());
        exp.setName(input.getName());
        exp.setReturnType(ExpressionHelper.getContractInputReturnType(input));
        exp.getReferencedElements().add((Object)ExpressionHelper.createDependencyFromEObject((EObject)input));
        return exp;
    }

    private static String getContractInputReturnType(ContractInput input) {
        if (input == null) {
            return null;
        }
        String returnType = input.getJavaType();
        if (input.isMultiple()) {
            returnType = List.class.getName();
        }
        return returnType;
    }

    public static Expression createConnectorOutputExpression(Output output) {
        Expression exp = ExpressionFactory.eINSTANCE.createExpression();
        exp.setType("CONNECTOR_OUTPUT_TYPE");
        exp.setContent(output.getName());
        exp.setName(output.getName());
        exp.setReturnType(output.getType());
        exp.getReferencedElements().add((Object)ExpressionHelper.createDependencyFromEObject((EObject)output));
        return exp;
    }

    private static Expression createParameterExpression(Parameter p) {
        Expression exp = ExpressionFactory.eINSTANCE.createExpression();
        exp.setType("TYPE_PARAMETER");
        exp.setContent(p.getName());
        exp.setName(p.getName());
        exp.setReturnType(p.getTypeClassname());
        exp.getReferencedElements().add((Object)ExpressionHelper.createDependencyFromEObject((EObject)p));
        return exp;
    }

    public static Expression createDocumentExpressionWithDependency(org.bonitasoft.bpm.model.process.Document document) {
        Expression expression = ExpressionFactory.eINSTANCE.createExpression();
        expression.setContent(document.getName());
        expression.setName(document.getName());
        expression.setType("TYPE_DOCUMENT");
        expression.setReturnType(String.class.getName());
        if (document.isMultiple()) {
            expression.setReturnType(List.class.getName());
        } else {
            expression.setReturnType(Document.class.getName());
        }
        expression.getReferencedElements().add((Object)ExpressionHelper.createDependencyFromEObject((EObject)document));
        return expression;
    }

    public static Data dataFromIteratorExpression(MultiInstantiable parentFlowElement, Expression iteratorExpression, MainProcess mainProcess) {
        String returnType = iteratorExpression.getReturnType();
        BusinessObjectData d = null;
        if (returnType != null) {
            DataType dt = ExpressionHelper.getDataTypeFrom(returnType, mainProcess, parentFlowElement);
            if (dt instanceof BusinessObjectType) {
                d = ProcessFactory.eINSTANCE.createBusinessObjectData();
                ((JavaObjectData)d).setClassName(returnType);
            } else if (dt instanceof JavaType) {
                d = ProcessFactory.eINSTANCE.createJavaObjectData();
                ((JavaObjectData)d).setClassName(returnType);
            } else {
                d = ProcessFactory.eINSTANCE.createData();
            }
            d.setName(iteratorExpression.getName());
            d.setDataType(dt);
        }
        return d;
    }

    private static DataType getDataTypeFrom(String returnType, MainProcess mainProcess, MultiInstantiable parentFlowElement) {
        if (parentFlowElement.getCollectionDataToMultiInstantiate() instanceof BusinessObjectData) {
            return mainProcess.getDatatypes().stream().filter(BusinessObjectType.class::isInstance).findFirst().orElse(null);
        }
        return ExpressionHelper.getDataTypeByClassName(mainProcess, returnType);
    }

    static DataType getDataTypeByClassName(MainProcess dataTypeContainer, String returnTypeClassname) {
        Objects.requireNonNull(dataTypeContainer);
        Objects.requireNonNull(returnTypeClassname);
        if (returnTypeClassname.equals(Boolean.class.getName())) {
            return dataTypeContainer.getDatatypes().stream().filter(BooleanType.class::isInstance).findFirst().orElse(null);
        }
        if (returnTypeClassname.equals(String.class.getName())) {
            return dataTypeContainer.getDatatypes().stream().filter(StringType.class::isInstance).filter(Predicate.not(DateType.class::isInstance)).findFirst().orElse(null);
        }
        if (returnTypeClassname.equals(Double.class.getName())) {
            return dataTypeContainer.getDatatypes().stream().filter(DoubleType.class::isInstance).findFirst().orElse(null);
        }
        if (returnTypeClassname.equals(Long.class.getName())) {
            return dataTypeContainer.getDatatypes().stream().filter(LongType.class::isInstance).findFirst().orElse(null);
        }
        if (returnTypeClassname.equals(Integer.class.getName())) {
            return dataTypeContainer.getDatatypes().stream().filter(IntegerType.class::isInstance).findFirst().orElse(null);
        }
        if (returnTypeClassname.equals(Date.class.getName())) {
            return dataTypeContainer.getDatatypes().stream().filter(DateType.class::isInstance).findFirst().orElse(null);
        }
        return dataTypeContainer.getDatatypes().stream().filter(JavaType.class::isInstance).findFirst().orElse(null);
    }
}

