/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bar;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.project.MavenProject;
import org.bonitasoft.bonita2bar.BarBuilder;
import org.bonitasoft.bonita2bar.BuildBarException;
import org.bonitasoft.bonita2bar.ClasspathResolver;
import org.bonitasoft.bonita2bar.ConnectorImplementationRegistry;
import org.bonitasoft.bonita2bar.MavenExecutor;
import org.bonitasoft.bonita2bar.ProcessRegistry;
import org.bonitasoft.bonita2bar.SourcePathProvider;
import org.bonitasoft.bonita2bar.actor.ActorMappingArtifactProvider;
import org.bonitasoft.bonita2bar.classpath.ConnectorImplementationArtifactProvider;
import org.bonitasoft.bonita2bar.classpath.CustomGroovyArtifactProvider;
import org.bonitasoft.bonita2bar.classpath.DependenciesArtifactProvider;
import org.bonitasoft.bonita2bar.classpath.WithoutDependencyJarsArtifactProvider;
import org.bonitasoft.bonita2bar.configuration.ParameterArtifactProvider;
import org.bonitasoft.bonita2bar.configuration.model.ParametersConfiguration;
import org.bonitasoft.bonita2bar.form.FormBuilder;
import org.bonitasoft.bonita2bar.form.FormMappingArtifactProvider;
import org.bonitasoft.bonita2bar.internal.M2eMavenExecutor;
import org.bonitasoft.bonita2bar.process.ProcessDefinitionArtifactProvider;
import org.bonitasoft.bonita2bar.process.pomgen.ProcessPomGenerator;
import org.bonitasoft.bonita2bar.resources.AdditionalResourcesArtifactProvider;
import org.bonitasoft.bonita2bar.resources.BPMN2ArtifactProvider;
import org.bonitasoft.bonita2bar.resources.DocumentArtifactProvider;
import org.bonitasoft.bpm.model.util.EnvironmentUtil;

public class BarBuilderFactory {
    private BarBuilderFactory() {
    }

    public static BarBuilder create(BuildConfig config) {
        ParametersConfiguration parametersConfiguration = new ParametersConfiguration();
        SourcePathProvider sourceProvider = config.getSourcePathProvider();
        ProcessRegistry processRegistry = config.getProcessRegistry();
        ConnectorImplementationRegistry implementationRegistry = config.getConnectorImplementationRegistry();
        ClasspathResolver classpathResolver = config.getClasspathResolver();
        Path workingDirectory = config.getWorkingDirectory();
        ProcessPomGenerator pomGen = ProcessPomGenerator.create(config.getMavenProject(), implementationRegistry);
        BarBuilder barBuilder = new BarBuilder(processRegistry, sourceProvider.getLocalConfiguration(), parametersConfiguration, workingDirectory, pomGen);
        barBuilder.register(new ParameterArtifactProvider(parametersConfiguration, config.includeParameters()));
        barBuilder.register(new ActorMappingArtifactProvider());
        barBuilder.register(new ProcessDefinitionArtifactProvider(config.getProcessRegistry()));
        if (config.withDependencyJars) {
            barBuilder.register(new DependenciesArtifactProvider(config.getMavenExecutor()));
        } else {
            barBuilder.register(new WithoutDependencyJarsArtifactProvider());
        }
        barBuilder.register(new FormMappingArtifactProvider(sourceProvider.getForms(), config.getFormBuilder(), config.allowEmptyFormMapping()));
        barBuilder.register(new BPMN2ArtifactProvider(processRegistry, workingDirectory));
        barBuilder.register(new DocumentArtifactProvider(sourceProvider.getAttachments()));
        barBuilder.register(new CustomGroovyArtifactProvider(sourceProvider.getGroovySource(), classpathResolver, workingDirectory));
        barBuilder.register(new ConnectorImplementationArtifactProvider(implementationRegistry, "CONNECTOR"));
        barBuilder.register(new ConnectorImplementationArtifactProvider(implementationRegistry, "ACTOR_FILTER"));
        barBuilder.register(new AdditionalResourcesArtifactProvider(sourceProvider.getResources()));
        return barBuilder;
    }

    public static class BuildConfig {
        private boolean allowEmptyFormMapping;
        private boolean includeParameters;
        private Path workingDirectory;
        private ConnectorImplementationRegistry connectorImplementationRegistry;
        private FormBuilder formBuilder;
        private ProcessRegistry processRegistry;
        private MavenProject mavenProject;
        private SourcePathProvider sourcePathProvider;
        private ClasspathResolver classpathResolver;
        private MavenExecutor mavenExecutor;
        private boolean withDependencyJars;

        private BuildConfig(BuildConfigBuilder builder) throws BuildBarException {
            this.allowEmptyFormMapping = builder.allowEmptyFormMapping;
            this.includeParameters = builder.includeParameters;
            this.workingDirectory = builder.workingDirectory;
            this.connectorImplementationRegistry = builder.connectorImplementationRegistry;
            this.formBuilder = builder.formBuilder;
            this.processRegistry = builder.processRegistry;
            this.mavenProject = builder.mavenProject;
            this.sourcePathProvider = Optional.ofNullable(builder.sourcePathProvider).orElseGet(() -> {
                Optional<File> baseDir = Optional.ofNullable(this.mavenProject).map(MavenProject::getBasedir).filter(Objects::nonNull);
                return baseDir.map(File::toPath).map(SourcePathProvider::of).orElse(null);
            });
            this.mavenExecutor = Optional.ofNullable(builder.mavenExecutor).orElseGet(() -> EnvironmentUtil.isOSGi() ? new M2eMavenExecutor() : MavenExecutor.getCliImplementation());
            AtomicReference exceptionDuringClasspathResolver = new AtomicReference();
            this.withDependencyJars = builder.withDependencyJars;
            this.classpathResolver = Optional.ofNullable(builder.classpathResolver).orElseGet(() -> {
                if (this.mavenProject != null) {
                    try {
                        List<String> classpath = Stream.concat(this.mavenProject.getCompileClasspathElements().stream(), this.mavenProject.getRuntimeClasspathElements().stream()).distinct().collect(Collectors.toList());
                        if (!classpath.isEmpty()) {
                            return ClasspathResolver.of(classpath);
                        }
                    }
                    catch (DependencyResolutionRequiredException e) {
                        exceptionDuringClasspathResolver.set(e);
                    }
                }
                return null;
            });
            if (exceptionDuringClasspathResolver.get() != null) {
                throw new BuildBarException((Throwable)exceptionDuringClasspathResolver.get());
            }
        }

        public MavenExecutor getMavenExecutor() {
            return this.mavenExecutor;
        }

        public boolean includeParameters() {
            return this.includeParameters;
        }

        public boolean allowEmptyFormMapping() {
            return this.allowEmptyFormMapping;
        }

        public Path getWorkingDirectory() {
            Objects.requireNonNull(this.workingDirectory, "No workingDirectory configured.");
            return this.workingDirectory;
        }

        public ConnectorImplementationRegistry getConnectorImplementationRegistry() {
            Objects.requireNonNull(this.connectorImplementationRegistry, "No ConnectorImplementationRegistry configured.");
            return this.connectorImplementationRegistry;
        }

        public FormBuilder getFormBuilder() {
            Objects.requireNonNull(this.formBuilder, "No FormBuilder configured.");
            return this.formBuilder;
        }

        public ProcessRegistry getProcessRegistry() {
            Objects.requireNonNull(this.processRegistry, "No ProcessRegistry configured.");
            return this.processRegistry;
        }

        public MavenProject getMavenProject() {
            Objects.requireNonNull(this.mavenProject, "No MavenProject configured.");
            return this.mavenProject;
        }

        public SourcePathProvider getSourcePathProvider() {
            Objects.requireNonNull(this.sourcePathProvider, "No SourcePathProvider configured.");
            return this.sourcePathProvider;
        }

        public ClasspathResolver getClasspathResolver() {
            Objects.requireNonNull(this.classpathResolver, "No ClasspathResolver configured.");
            return this.classpathResolver;
        }

        public static BuildConfigBuilder builder() {
            return new BuildConfigBuilder();
        }

        public static class BuildConfigBuilder {
            private boolean allowEmptyFormMapping = true;
            private boolean includeParameters = false;
            private Path workingDirectory;
            private ConnectorImplementationRegistry connectorImplementationRegistry;
            private FormBuilder formBuilder;
            private ProcessRegistry processRegistry;
            private MavenProject mavenProject;
            private SourcePathProvider sourcePathProvider;
            private ClasspathResolver classpathResolver;
            private MavenExecutor mavenExecutor;
            private boolean withDependencyJars = true;

            private BuildConfigBuilder() {
            }

            public BuildConfig build() throws BuildBarException {
                return new BuildConfig(this);
            }

            public BuildConfigBuilder allowEmptyFormMapping(boolean allowEmptyFormMapping) {
                this.allowEmptyFormMapping = allowEmptyFormMapping;
                return this;
            }

            public BuildConfigBuilder includeParameters(boolean includeParameters) {
                this.includeParameters = includeParameters;
                return this;
            }

            public BuildConfigBuilder workingDirectory(Path workingDirectory) {
                this.workingDirectory = workingDirectory;
                return this;
            }

            public BuildConfigBuilder formBuilder(FormBuilder formBuilder) {
                this.formBuilder = formBuilder;
                return this;
            }

            public BuildConfigBuilder connectorImplementationRegistry(ConnectorImplementationRegistry connectorImplementationRegistry) {
                this.connectorImplementationRegistry = connectorImplementationRegistry;
                return this;
            }

            public BuildConfigBuilder processRegistry(ProcessRegistry processRegistry) {
                this.processRegistry = processRegistry;
                return this;
            }

            public BuildConfigBuilder sourcePathProvider(SourcePathProvider sourcePathProvider) {
                this.sourcePathProvider = sourcePathProvider;
                return this;
            }

            public BuildConfigBuilder classpathResolver(ClasspathResolver classpathResolver) {
                this.classpathResolver = classpathResolver;
                return this;
            }

            public BuildConfigBuilder mavenProject(MavenProject mavenProject) {
                this.mavenProject = mavenProject;
                return this;
            }

            public BuildConfigBuilder mavenExecutor(MavenExecutor mavenExecutor) {
                this.mavenExecutor = mavenExecutor;
                return this;
            }

            public BuildConfigBuilder withDependencyJars(boolean withDependencyJars) {
                this.withDependencyJars = withDependencyJars;
                return this;
            }
        }
    }
}

