/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bar;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.maven.cli.MavenCli;
import org.bonitasoft.bonita2bar.BuildBarException;

@FunctionalInterface
public interface MavenExecutor {
    public void execute(File var1, List<String> var2, Map<String, String> var3, List<String> var4, Supplier<String> var5) throws BuildBarException;

    public static MavenExecutor getCliImplementation() {
        return (pomFile, goals, properties, activeProfiles, errorMessageBase) -> {
            File pomFolder = pomFile.getParentFile();
            Stream<String> argumentsStream = Stream.concat(Stream.concat(goals.stream(), properties.entrySet().stream().map(e -> "-D" + (String)e.getKey() + "=" + (String)e.getValue())), Stream.concat(activeProfiles.stream().map(p -> "-P" + p), Stream.of("-q")));
            String[] args = (String[])argumentsStream.toArray(String[]::new);
            MavenCli cli = new MavenCli();
            System.setProperty("maven.multiModuleProjectDirectory", pomFolder.getAbsolutePath());
            try {
                Throwable throwable = null;
                Object var10_12 = null;
                try (ByteArrayOutputStream errStream = new ByteArrayOutputStream();){
                    int buildResult = cli.doMain(args, pomFolder.getAbsolutePath(), null, new PrintStream(errStream));
                    if (buildResult != 0) {
                        throw new BuildBarException((String)errorMessageBase.get() + "\n" + errStream.toString());
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e2) {
                throw new BuildBarException((String)errorMessageBase.get(), e2);
            }
        };
    }
}

