/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bar.actor;

import java.util.List;
import org.bonitasoft.bonita2bar.BarArtifactProvider;
import org.bonitasoft.bonita2bar.BuildBarException;
import org.bonitasoft.bpm.model.actormapping.ActorMappingsType;
import org.bonitasoft.bpm.model.actormapping.Groups;
import org.bonitasoft.bpm.model.actormapping.Membership;
import org.bonitasoft.bpm.model.actormapping.MembershipType;
import org.bonitasoft.bpm.model.actormapping.Roles;
import org.bonitasoft.bpm.model.actormapping.Users;
import org.bonitasoft.bpm.model.configuration.Configuration;
import org.bonitasoft.bpm.model.process.Pool;
import org.bonitasoft.engine.bpm.bar.BusinessArchiveBuilder;
import org.bonitasoft.engine.bpm.bar.actorMapping.Actor;
import org.bonitasoft.engine.bpm.bar.actorMapping.ActorMapping;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActorMappingArtifactProvider
implements BarArtifactProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActorMappingArtifactProvider.class);

    private boolean containsActorMapping(Configuration configuration) {
        return configuration.getActorMappings() != null && configuration.getActorMappings().getActorMapping() != null && !configuration.getActorMappings().getActorMapping().isEmpty();
    }

    private void cleanMapping(ActorMappingsType mapping) {
        for (org.bonitasoft.bpm.model.actormapping.ActorMapping m : mapping.getActorMapping()) {
            Users users;
            Roles roles;
            Membership memberships;
            Groups groups = m.getGroups();
            if (groups != null && groups.getGroup().isEmpty()) {
                m.setGroups(null);
            }
            if ((memberships = m.getMemberships()) != null && memberships.getMembership().isEmpty()) {
                m.setMemberships(null);
            }
            if ((roles = m.getRoles()) != null && roles.getRole().isEmpty()) {
                m.setRoles(null);
            }
            if ((users = m.getUsers()) == null || !users.getUser().isEmpty()) continue;
            m.setUsers(null);
        }
    }

    @Override
    public void build(BusinessArchiveBuilder builder, Pool process, Configuration configuration) throws BuildBarException {
        if (configuration == null || process.getActors().isEmpty()) {
            return;
        }
        if (!this.containsActorMapping(configuration)) {
            LOGGER.warn("No actor mapping found for environment {}", (Object)configuration.getName());
            return;
        }
        LOGGER.info("Adding actor mapping...");
        ActorMappingsType mapping = (ActorMappingsType)EcoreUtil.copy((EObject)configuration.getActorMappings());
        this.cleanMapping(mapping);
        ActorMapping actorMapping = new ActorMapping();
        this.addActorMappings(configuration, actorMapping);
        builder.setActorMapping(actorMapping);
    }

    private void addActorMappings(Configuration configuration, ActorMapping actorMapping) {
        for (org.bonitasoft.bpm.model.actormapping.ActorMapping actorMappingDev : configuration.getActorMappings().getActorMapping()) {
            actorMapping.addActor(this.createActor(actorMappingDev));
        }
    }

    private Actor createActor(org.bonitasoft.bpm.model.actormapping.ActorMapping actorMappingDev) {
        Membership memberships;
        Roles roles;
        Groups groups;
        Actor actor = new Actor(actorMappingDev.getName());
        Users users = actorMappingDev.getUsers();
        if (users != null) {
            actor.addUsers((List)users.getUser());
        }
        if ((groups = actorMappingDev.getGroups()) != null) {
            actor.addGroups((List)groups.getGroup());
        }
        if ((roles = actorMappingDev.getRoles()) != null) {
            actor.addRoles((List)roles.getRole());
        }
        if ((memberships = actorMappingDev.getMemberships()) != null) {
            for (MembershipType membershipType : memberships.getMembership()) {
                actor.addMembership(membershipType.getGroup(), membershipType.getRole());
            }
        }
        return actor;
    }
}

