/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bar.classpath;

import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bonitasoft.bonita2bar.BarArtifactProvider;
import org.bonitasoft.bonita2bar.BuildBarException;
import org.bonitasoft.bonita2bar.ClasspathResolver;
import org.bonitasoft.bonita2bar.classpath.JarBuilder;
import org.bonitasoft.bpm.model.configuration.Configuration;
import org.bonitasoft.bpm.model.process.Pool;
import org.bonitasoft.bpm.model.util.EnvironmentUtil;
import org.bonitasoft.bpm.model.util.FileUtil;
import org.bonitasoft.engine.bpm.bar.BarResource;
import org.bonitasoft.engine.bpm.bar.BusinessArchiveBuilder;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.ProcessingUnit;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SimpleMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomGroovyArtifactProvider
implements BarArtifactProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomGroovyArtifactProvider.class);
    static final String GROOVYSCRIPT_JAR = "groovyscripts.jar";
    static final String GROOVY_SOURCE_FOLDER = "src-groovy";
    private ClasspathResolver classpathResolver;
    private Path workingDirectory;
    private Path groovySource;

    public CustomGroovyArtifactProvider(Path groovySource, ClasspathResolver classpathResolver, Path workingDirectory) {
        this.groovySource = groovySource;
        this.classpathResolver = classpathResolver;
        this.workingDirectory = workingDirectory;
    }

    @Override
    public void build(BusinessArchiveBuilder builder, Pool process, Configuration configuration) throws BuildBarException {
        LOGGER.info("Adding custom groovy scripts in classpath...");
        Path targetClasses = this.workingDirectory.resolve("groovy-classes");
        if (Files.exists(targetClasses, new LinkOption[0])) {
            try {
                FileUtil.deleteDir((Path)targetClasses);
            }
            catch (IOException e) {
                throw new BuildBarException(String.format("Failed to delete folder %s", targetClasses), e);
            }
        }
        Path outputJarFile = this.workingDirectory.resolve(GROOVYSCRIPT_JAR);
        try {
            Files.deleteIfExists(outputJarFile);
        }
        catch (IOException e) {
            throw new BuildBarException(String.format("Failed to delete custom groovy jar %s.", outputJarFile), e);
        }
        Set<File> filesToCompile = this.collectGroovySourceFile(this.groovySource, process);
        if (filesToCompile.isEmpty()) {
            LOGGER.info("No custom groovy script to compile found.");
            return;
        }
        try {
            Files.createDirectories(targetClasses, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new BuildBarException(String.format("Failed to create folder %s", targetClasses), e);
        }
        try {
            this.compile(filesToCompile, targetClasses.toFile());
        }
        catch (IOException | CompilationFailedException e) {
            throw new BuildBarException(String.format("Failed to compile custom groovy files for %s (%s)", process.getName(), process.getVersion()), e);
        }
        try {
            Path jarFile = JarBuilder.createJar(targetClasses.toFile(), outputJarFile);
            builder.addClasspathResource(new BarResource(GROOVYSCRIPT_JAR, Files.readAllBytes(jarFile)));
        }
        catch (IOException e) {
            throw new BuildBarException(String.format("Failed to add custom groovy jar in %s (%s) bar.", process.getName(), process.getVersion()), e);
        }
    }

    private void compile(Set<File> filesToCompile, File targetClasses) throws IOException, CompilationFailedException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (GroovyClassLoader classLoader = new GroovyClassLoader();){
            this.selectDependencies().forEach(arg_0 -> ((GroovyClassLoader)classLoader).addURL(arg_0));
            CompilerConfiguration configuration = new CompilerConfiguration();
            configuration.setTargetDirectory(targetClasses.getAbsolutePath());
            configuration.setSourceEncoding("utf-8");
            configuration.setTargetBytecode("17");
            CompilationUnit compileUnit = new CompilationUnit(configuration, null, classLoader);
            compileUnit.addSources(filesToCompile.toArray(new File[filesToCompile.size()]));
            if (EnvironmentUtil.isOSGi()) {
                compileUnit.addPhaseOperation(groovyClass -> {
                    String name = groovyClass.getName().replace('.', File.separatorChar) + ".class";
                    File path = new File(configuration.getTargetDirectory(), name);
                    File directory = path.getParentFile();
                    Optional.ofNullable(directory).filter(d -> !d.exists()).ifPresent(File::mkdirs);
                    try {
                        Throwable throwable = null;
                        Object var7_9 = null;
                        try (FileOutputStream stream = new FileOutputStream(path);){
                            byte[] bytes = groovyClass.getBytes();
                            stream.write(bytes, 0, bytes.length);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        compileUnit.getErrorCollector().addError((Message)new SimpleMessage(e.getMessage(), (ProcessingUnit)compileUnit));
                    }
                });
            }
            compileUnit.compile();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private List<URL> selectDependencies() throws IOException {
        return this.classpathResolver.listFiles().stream().map(File::toURI).map(uri -> {
            try {
                LOGGER.debug("{} added to compilation classpath", uri);
                return uri.toURL();
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException(e);
            }
        }).collect(Collectors.toList());
    }

    private Set<File> collectGroovySourceFile(Path groovySource, Pool process) throws BuildBarException {
        if (!Files.exists(groovySource, new LinkOption[0])) {
            return Set.of();
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Stream<Path> walker = Files.walk(groovySource, new FileVisitOption[0]);){
                List<Path> groovyPaths = walker.filter(path -> Files.isRegularFile(path, new LinkOption[0])).filter(file -> file.toString().endsWith(".groovy")).toList();
                return groovyPaths.stream().map(groovyPath -> {
                    LOGGER.info("{} added to compilation classpath.", (Object)groovySource.relativize((Path)groovyPath));
                    return groovyPath.toFile();
                }).collect(Collectors.toSet());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new BuildBarException(String.format("Failed to read custom groovy libraries for %s (%s) bar.", process.getName(), process.getVersion()), e);
        }
    }
}

