/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bar.classpath;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.maven.model.Model;
import org.bonitasoft.bonita2bar.BarArtifactProvider;
import org.bonitasoft.bonita2bar.BuildBarException;
import org.bonitasoft.bonita2bar.MavenExecutor;
import org.bonitasoft.bonita2bar.process.pomgen.ProcessPom;
import org.bonitasoft.bpm.model.configuration.Configuration;
import org.bonitasoft.bpm.model.process.Pool;
import org.bonitasoft.engine.bpm.bar.BarResource;
import org.bonitasoft.engine.bpm.bar.BusinessArchiveBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class DependenciesArtifactProvider
implements BarArtifactProvider {
    private static final String ENV_PROFILE_FORMAT = "env-%s";
    private MavenExecutor mavenExecutor;

    public DependenciesArtifactProvider(MavenExecutor mavenExecutor) {
        this.mavenExecutor = mavenExecutor;
    }

    @Override
    public void build(BusinessArchiveBuilder builder, Pool process, ProcessPom pomAccess, Configuration configuration) throws BuildBarException {
        try {
            Model pom = pomAccess.readPom();
            File processPomFolder = pom.getPomFile().getParentFile();
            File dependenciesFolder = new File(processPomFolder, "dependencies");
            String profileToUse = String.format(ENV_PROFILE_FORMAT, configuration.getName());
            Supplier<String> errMsg = () -> String.format("Failed to build dependencies for process %s-%s", process.getName(), process.getVersion());
            this.mavenExecutor.execute(pom.getPomFile(), List.of("dependency:copy-dependencies"), Map.of("outputDirectory", "./" + dependenciesFolder.getName()), List.of(profileToUse), errMsg);
            if (dependenciesFolder.exists()) {
                this.exploreDependencies(builder, dependenciesFolder);
            }
        }
        catch (IOException | XmlPullParserException e) {
            throw new BuildBarException(String.format("Failed to add dependencies in bar %s-%s.bar.", process.getName(), process.getVersion()), e);
        }
    }

    private void exploreDependencies(BusinessArchiveBuilder builder, File dependenciesFolder) throws BuildBarException, IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (Stream<Path> walker = Files.walk(dependenciesFolder.toPath(), new FileVisitOption[0]);){
            List<Path> files = walker.filter(path -> Files.isRegularFile(path, new LinkOption[0])).toList();
            for (Path file : files) {
                this.addDependencyToBuild(builder, file);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void addDependencyToBuild(BusinessArchiveBuilder builder, Path file) throws BuildBarException {
        try {
            BarResource barResource = new BarResource(file.getFileName().toString(), Files.readAllBytes(file));
            if (file.toString().endsWith(".jar")) {
                builder.addClasspathResource(barResource);
            } else {
                builder.addExternalResource(barResource);
            }
        }
        catch (IOException e) {
            throw new BuildBarException(String.format("Unable to get content of the %s ", file), e);
        }
    }
}

