/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bar.configuration;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentConfiguration {
    public static final String PARAMETERS_PROPERTIES_FILE = "parameters.properties";
    private static final Logger LOGGER = LoggerFactory.getLogger(EnvironmentConfiguration.class);
    private final Map<String, String> parameters;
    private String envName;
    private String processName;
    private String processVersion;

    EnvironmentConfiguration(String envName, String processName, String processVersion, Map<String, String> parameters) {
        this.envName = envName;
        this.processName = processName;
        this.processVersion = processVersion;
        this.parameters = parameters;
    }

    public void writeParameters(Path target) throws IOException {
        if (this.parameters != null && !this.parameters.isEmpty()) {
            Path processFolder = target.resolve(this.envName).resolve(this.processName).resolve(this.processVersion);
            processFolder.toFile().mkdirs();
            File parametersFile = processFolder.resolve(PARAMETERS_PROPERTIES_FILE).toFile();
            if (parametersFile.exists()) {
                Files.delete(parametersFile.toPath());
            }
            LOGGER.debug("Writing parameters file in {}", (Object)processFolder);
            Properties properties = new Properties();
            Throwable throwable = null;
            Object var6_7 = null;
            try (FileOutputStream out = new FileOutputStream(parametersFile);){
                for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
                    properties.setProperty(entry.getKey(), entry.getValue() == null ? "-==NULLL==-" : entry.getValue());
                }
                properties.store(out, this.envName);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }
}

