/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bar.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.bonitasoft.bonita2bar.BarArtifactProvider;
import org.bonitasoft.bonita2bar.configuration.EnvironmentConfigurationBuilder;
import org.bonitasoft.bonita2bar.configuration.model.Parameter;
import org.bonitasoft.bonita2bar.configuration.model.ParametersConfiguration;
import org.bonitasoft.bonita2bar.configuration.model.ProcessConfiguration;
import org.bonitasoft.bpm.model.configuration.Configuration;
import org.bonitasoft.bpm.model.configuration.ConfigurationFactory;
import org.bonitasoft.bpm.model.process.Pool;
import org.bonitasoft.engine.bpm.bar.BusinessArchiveBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterArtifactProvider
implements BarArtifactProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParameterArtifactProvider.class);
    private ParametersConfiguration parametersConfiguration;
    private boolean addParametersInBar;

    public ParameterArtifactProvider(ParametersConfiguration parametersConfiguration, boolean addParametersInBar) {
        this.parametersConfiguration = parametersConfiguration;
        this.addParametersInBar = addParametersInBar;
    }

    @Override
    public void build(BusinessArchiveBuilder builder, Pool process, Configuration configuration) {
        if (this.addParametersInBar) {
            builder.setParameters(this.toParameterMapFromConfiguration(configuration, process));
        }
    }

    @Override
    public void configure(EnvironmentConfigurationBuilder builder, Configuration configuration, Pool process) {
        ProcessConfiguration processConfiguration;
        if (configuration != null && !configuration.getParameters().isEmpty()) {
            LOGGER.info("Adding parameters for '{}' environment...", configuration.getName() != null ? configuration.getName().toLowerCase() : null);
        }
        if (!(processConfiguration = this.toProcessConfiguration(configuration, process)).getParameters().isEmpty()) {
            this.parametersConfiguration.getProcessConfigurations().add(processConfiguration);
        }
        builder.addParameters(this.toParameterMapFromConfiguration(configuration, process));
    }

    private Map<String, String> toParameterMapFromConfiguration(Configuration configuration, Pool process) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (configuration == null) {
            configuration = ConfigurationFactory.eINSTANCE.createConfiguration();
        }
        for (org.bonitasoft.bpm.model.parameter.Parameter defParam : process.getParameters()) {
            result.put(defParam.getName(), this.valueFromConfiguration(configuration, defParam));
        }
        return result;
    }

    private ProcessConfiguration toProcessConfiguration(Configuration configuration, Pool process) {
        if (configuration == null) {
            configuration = ConfigurationFactory.eINSTANCE.createConfiguration();
        }
        ProcessConfiguration.ProcessConfigurationBuilder builder = ProcessConfiguration.builder().name(process.getName()).version(process.getVersion());
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (org.bonitasoft.bpm.model.parameter.Parameter defParam : process.getParameters()) {
            parameters.add(Parameter.builder().name(defParam.getName()).description(defParam.getDescription()).type(this.toSimpleTypeName(defParam.getTypeClassname())).value(this.paramValue(configuration, defParam, defParam.getTypeClassname())).build());
            if (defParam.getDescription() != null) {
                LOGGER.debug("{} ({}) -- {}", new Object[]{defParam.getName(), defParam.getTypeClassname(), defParam.getDescription()});
                continue;
            }
            LOGGER.debug("{} ({})", (Object)defParam.getName(), (Object)defParam.getTypeClassname());
        }
        return builder.parameters(parameters).build();
    }

    private Object paramValue(Configuration configuration, org.bonitasoft.bpm.model.parameter.Parameter p, String type) {
        String value = this.valueFromConfiguration(configuration, p);
        return value != null && !value.isEmpty() ? this.convertValue(value, type) : null;
    }

    private String valueFromConfiguration(Configuration configuration, org.bonitasoft.bpm.model.parameter.Parameter p) {
        return configuration.getParameters().stream().filter(param -> Objects.equals(param.getName(), p.getName())).findFirst().map(param -> this.interpretNullValue(param.getValue())).orElse(null);
    }

    private String interpretNullValue(String value) {
        return value == null || value.isEmpty() ? null : value;
    }

    private String toSimpleTypeName(String typeClassname) {
        switch (typeClassname) {
            case "java.lang.String": {
                return "String";
            }
            case "java.lang.Integer": {
                return "Integer";
            }
            case "java.lang.Boolean": {
                return "Boolean";
            }
            case "java.lang.Double": {
                return "Decimal";
            }
        }
        throw new IllegalStateException(String.format("Unknown parameter type: %s", typeClassname));
    }

    private Object convertValue(String value, String typeClassname) {
        switch (typeClassname) {
            case "java.lang.String": {
                return String.valueOf(value);
            }
            case "java.lang.Integer": {
                return Integer.valueOf(value);
            }
            case "java.lang.Boolean": {
                return Boolean.valueOf(value);
            }
            case "java.lang.Double": {
                return Double.valueOf(value);
            }
        }
        throw new IllegalStateException(String.format("Unknown parameter type: %s", typeClassname));
    }
}

