/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bar.configuration;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bonitasoft.bonita2bar.configuration.ConfigurationArchive;
import org.bonitasoft.bonita2bar.configuration.ParametersConfigurationMapper;
import org.bonitasoft.bonita2bar.configuration.model.Parameter;
import org.bonitasoft.bonita2bar.configuration.model.ParametersConfiguration;
import org.bonitasoft.bonita2bar.configuration.model.ProcessConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterConfigurationExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParameterConfigurationExtractor.class);
    private ParametersConfigurationMapper mapper = new ParametersConfigurationMapper();

    public void extract(File configurationArchiveFile, String outputFile, boolean withoutValue) throws IOException {
        ConfigurationArchive configurationArchive = new ConfigurationArchive(configurationArchiveFile);
        ParametersConfiguration conf = configurationArchive.loadParametersConfiguration();
        boolean hasParameter = withoutValue ? this.extractWithoutValueOnly(outputFile, conf) : this.extractAll(outputFile, conf);
        LOGGER.info("");
        if (hasParameter) {
            LOGGER.info("Parameter descriptor file has been extracted to {}.", (Object)new File(outputFile).getCanonicalFile().getAbsolutePath());
        } else {
            LOGGER.info("No parameters found. No file extracted.");
        }
    }

    private boolean extractWithoutValueOnly(String outputFile, ParametersConfiguration conf) throws IOException {
        boolean hasParameter = false;
        ParametersConfiguration removeValuatedParameters = this.removeValuatedParameters(conf);
        for (ProcessConfiguration pConf : removeValuatedParameters.getProcessConfigurations()) {
            LOGGER.info("");
            LOGGER.info("[{} - {}]", (Object)pConf.getName(), (Object)pConf.getVersion());
            for (Parameter p : pConf.getParameters()) {
                hasParameter = true;
                this.printParam(p);
            }
        }
        if (hasParameter) {
            this.mapper.writeToFile(removeValuatedParameters, new File(outputFile).getCanonicalFile().toPath());
        }
        return hasParameter;
    }

    private boolean extractAll(String outputFile, ParametersConfiguration conf) throws IOException {
        List processWithParams = conf.getProcessConfigurations().stream().filter(process -> !process.getParameters().isEmpty()).collect(Collectors.toList());
        boolean hasParameter = !processWithParams.isEmpty();
        for (ProcessConfiguration pConf : processWithParams) {
            LOGGER.info("");
            LOGGER.info("[{} - {}]", (Object)pConf.getName(), (Object)pConf.getVersion());
            ArrayList<Parameter> paramsWithoutValue = new ArrayList<Parameter>();
            for (Parameter p : pConf.getParameters()) {
                if (p.getValue() == null) {
                    paramsWithoutValue.add(p);
                    continue;
                }
                this.printParam(p);
            }
            if (paramsWithoutValue.isEmpty()) continue;
            LOGGER.info("-- Parameters without value --");
            for (Parameter param : paramsWithoutValue) {
                this.printParam(param);
            }
        }
        if (hasParameter) {
            this.mapper.writeToFile(conf, new File(outputFile).getCanonicalFile().toPath());
        }
        return hasParameter;
    }

    private void printParam(Parameter p) {
        if (p.getDescription() != null && !p.getDescription().isEmpty()) {
            LOGGER.info("{} ({}) -- {}", new Object[]{p.getName(), p.getType(), p.getDescription()});
        } else {
            LOGGER.info("{} ({})", (Object)p.getName(), (Object)p.getType());
        }
    }

    private ParametersConfiguration removeValuatedParameters(ParametersConfiguration conf) {
        for (ProcessConfiguration pConf : conf.getProcessConfigurations()) {
            if (pConf.getParameters() == null) continue;
            pConf.getParameters().removeIf(p -> p.getValue() != null);
        }
        conf.getProcessConfigurations().removeIf(p -> p.getParameters() == null || p.getParameters().isEmpty());
        return conf;
    }
}

