/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bar.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.bonitasoft.bonita2bar.configuration.ConfigurationArchive;
import org.bonitasoft.bonita2bar.configuration.ParameterUpdateStatus;
import org.bonitasoft.bonita2bar.configuration.ParametersConfigurationMapper;
import org.bonitasoft.bonita2bar.configuration.ZipUtil;
import org.bonitasoft.bonita2bar.configuration.model.Parameter;
import org.bonitasoft.bonita2bar.configuration.model.ParametersConfiguration;
import org.bonitasoft.bonita2bar.configuration.model.ProcessConfiguration;
import org.bonitasoft.bpm.model.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParametersConfigurationMerger {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParametersConfigurationMerger.class);
    private ParametersConfigurationMapper mapper = new ParametersConfigurationMapper();

    public void merge(File configurationArchiveFile, File inputParameterFile, String output) throws IOException {
        ConfigurationArchive configurationArchive = new ConfigurationArchive(configurationArchiveFile);
        ParametersConfiguration conf = configurationArchive.loadParametersConfiguration();
        ParametersConfiguration confToMerge = this.mapper.read(inputParameterFile);
        List<Parameter> allParameters = conf.getProcessConfigurations().stream().map(ProcessConfiguration::getParameters).flatMap(Collection::stream).collect(Collectors.toList());
        List<Parameter> globalParameters = confToMerge.getGlobalParameters();
        ParameterUpdateStatus globalStatus = this.updateParameterValue(allParameters, globalParameters);
        LOGGER.info("");
        globalStatus.getUpdatedParameters().stream().map(p -> String.format("Parameter %s (%s) has been updated using global parameters.", p.getName(), p.getType())).forEach(arg_0 -> ((Logger)LOGGER).info(arg_0));
        globalStatus.getDuplicates().stream().map(p -> String.format("Parameter %s (%s) is duplicated in global_parameters of %s", p.getName(), p.getType(), inputParameterFile.getName())).forEach(arg_0 -> ((Logger)LOGGER).warn(arg_0));
        for (ProcessConfiguration pConf : conf.getProcessConfigurations()) {
            List matchingProcesses = confToMerge.getProcessConfigurations().stream().filter(process -> Objects.equals(process.getName(), pConf.getName())).filter(process -> Objects.equals(process.getVersion(), pConf.getVersion())).collect(Collectors.toList());
            if (matchingProcesses.size() > 1) {
                LOGGER.warn("Duplicated process found with name '{}' and version '{}' in {}.", new Object[]{pConf.getName(), pConf.getVersion(), inputParameterFile.getName()});
            }
            if (matchingProcesses.isEmpty()) continue;
            ProcessConfiguration processConfiguration = (ProcessConfiguration)matchingProcesses.get(0);
            ParameterUpdateStatus processStatus = this.updateParameterValue(pConf.getParameters(), processConfiguration.getParameters());
            processStatus.getUpdatedParameters().stream().map(p -> String.format("Parameter %s (%s) has been updated using '%s-%s' process parameter.", p.getName(), p.getType(), processConfiguration.getName(), processConfiguration.getVersion())).forEach(arg_0 -> ((Logger)LOGGER).info(arg_0));
            processStatus.getDuplicates().stream().map(p -> String.format("Parameter %s (%s) is duplicated in process parameters of '%s-%s' in %s", p.getName(), p.getType(), processConfiguration.getName(), processConfiguration.getVersion(), inputParameterFile.getName())).forEach(arg_0 -> ((Logger)LOGGER).warn(arg_0));
        }
        File outputFile = new File(output).getCanonicalFile();
        if (!configurationArchiveFile.equals(outputFile)) {
            Files.copy(configurationArchiveFile.toPath(), outputFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        this.update(outputFile, conf);
        LOGGER.info("");
        if (!configurationArchiveFile.equals(outputFile)) {
            LOGGER.info("{} has been created.", (Object)output);
        } else {
            LOGGER.info("{} has been updated.", (Object)output);
        }
    }

    protected ParameterUpdateStatus updateParameterValue(List<Parameter> allParameters, List<Parameter> globalParameters) {
        ParameterUpdateStatus parameterUpdateStatus = new ParameterUpdateStatus();
        for (Parameter p : allParameters) {
            List matchingParams = globalParameters.stream().filter(param -> Objects.equals(param.getName(), p.getName())).filter(param -> Objects.equals(param.getType(), p.getType())).collect(Collectors.toList());
            if (matchingParams.size() > 1) {
                parameterUpdateStatus.getDuplicates().add(p);
            }
            if (matchingParams.isEmpty()) continue;
            Parameter parameter = (Parameter)matchingParams.get(0);
            if (Objects.equals(p.getValue(), parameter.getValue())) continue;
            p.setValue(parameter.getValue());
            parameterUpdateStatus.getUpdatedParameters().add(parameter);
        }
        return parameterUpdateStatus;
    }

    private void update(File configurationArchiveFile, ParametersConfiguration conf) throws IOException {
        Path tmpFolder = Files.createTempDirectory(configurationArchiveFile.getName(), new FileAttribute[0]);
        ZipUtil.unzip(configurationArchiveFile, tmpFolder);
        this.mapper.writeToFile(conf, tmpFolder.resolve("parameters.yml"));
        for (ProcessConfiguration pConf : conf.getProcessConfigurations()) {
            Path propertiesFile = tmpFolder.resolve(pConf.getName()).resolve(pConf.getVersion()).resolve("parameters.properties");
            Properties properties = new Properties();
            Throwable throwable = null;
            Object var9_11 = null;
            try (FileInputStream is = new FileInputStream(propertiesFile.toFile());){
                properties.load(is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            pConf.getParameters().stream().forEach(p -> {
                Object object = properties.setProperty(p.getName(), String.valueOf(p.getValue() == null ? "-==NULLL==-" : p.getValue()));
            });
            throwable = null;
            var9_11 = null;
            try (FileOutputStream out = new FileOutputStream(propertiesFile.toFile());){
                properties.store(out, null);
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        Files.deleteIfExists(configurationArchiveFile.toPath());
        ZipUtil.zip(tmpFolder, configurationArchiveFile.toPath());
        FileUtil.deleteDir((Path)tmpFolder);
    }
}

