/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bar.configuration.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;

public class Parameter {
    private String name;
    private Object value;
    private String type;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String description;

    public Parameter() {
    }

    public Parameter(String name, Object value, String type, String description) {
        this.name = name;
        this.value = value;
        this.type = type;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int hashCode() {
        return Objects.hash(this.description, this.name, this.type, this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Parameter other = (Parameter)obj;
        return Objects.equals(this.description, other.description) && Objects.equals(this.name, other.name) && Objects.equals(this.type, other.type) && Objects.equals(this.value, other.value);
    }

    public static ParameterBuilder builder() {
        return new ParameterBuilder();
    }

    public static class ParameterBuilder {
        private String name;
        private Object value;
        private String type;
        private String description;

        ParameterBuilder() {
        }

        public ParameterBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ParameterBuilder value(Object value) {
            this.value = value;
            return this;
        }

        public ParameterBuilder type(String type) {
            this.type = type;
            return this;
        }

        public ParameterBuilder description(String description) {
            this.description = description;
            return this;
        }

        public Parameter build() {
            return new Parameter(this.name, this.value, this.type, this.description);
        }
    }
}

