/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bar.configuration.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.bonitasoft.bonita2bar.configuration.model.Parameter;
import org.bonitasoft.bonita2bar.configuration.model.ProcessConfiguration;

public class ParametersConfiguration {
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonProperty(value="processes")
    private List<ProcessConfiguration> processConfigurations = new ArrayList<ProcessConfiguration>();
    @JsonProperty(value="global_parameters")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<Parameter> globalParameters = new ArrayList<Parameter>();

    public ParametersConfiguration() {
    }

    public ParametersConfiguration(List<ProcessConfiguration> processConfigurations, List<Parameter> globalParameters) {
        this.processConfigurations = processConfigurations;
        this.globalParameters = globalParameters;
    }

    public List<ProcessConfiguration> getProcessConfigurations() {
        return this.processConfigurations;
    }

    public void setProcessConfigurations(List<ProcessConfiguration> processConfigurations) {
        this.processConfigurations = processConfigurations;
    }

    public List<Parameter> getGlobalParameters() {
        return this.globalParameters;
    }

    public void setGlobalParameters(List<Parameter> globalParameters) {
        this.globalParameters = globalParameters;
    }

    public int hashCode() {
        return Objects.hash(this.globalParameters, this.processConfigurations);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParametersConfiguration other = (ParametersConfiguration)obj;
        return Objects.equals(this.globalParameters, other.globalParameters) && Objects.equals(this.processConfigurations, other.processConfigurations);
    }

    public static ParametersConfigurationBuilder builder() {
        return new ParametersConfigurationBuilder();
    }

    public static class ParametersConfigurationBuilder {
        private List<ProcessConfiguration> processConfigurations = new ArrayList<ProcessConfiguration>();
        private List<Parameter> globalParameters = new ArrayList<Parameter>();

        ParametersConfigurationBuilder() {
        }

        public ParametersConfigurationBuilder processConfigurations(List<ProcessConfiguration> processConfigurations) {
            this.processConfigurations = processConfigurations;
            return this;
        }

        public ParametersConfigurationBuilder globalParameters(List<Parameter> globalParameters) {
            this.globalParameters = globalParameters;
            return this;
        }

        public ParametersConfiguration build() {
            return new ParametersConfiguration(this.processConfigurations, this.globalParameters);
        }
    }
}

