/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bar.form;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageUUIDResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(PageUUIDResolver.class);
    private File pageFolder;
    private ObjectMapper objectMapper = new ObjectMapper();

    public PageUUIDResolver(File pageFolder) {
        this.pageFolder = pageFolder;
    }

    public static File indexFile(File pageFolder) {
        return pageFolder.toPath().resolve(".metadata").resolve(".index.json").toFile();
    }

    public String resolveUUID(String uuid) {
        File indexFile = PageUUIDResolver.indexFile(this.pageFolder);
        if (!indexFile.exists()) {
            return null;
        }
        Map<String, Object> index = this.toJSONObject(indexFile.toPath());
        if (index == null || !index.containsKey(uuid)) {
            return null;
        }
        return (String)index.get(uuid);
    }

    private Map<String, Object> toJSONObject(Path file) {
        try {
            TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
            return (Map)this.objectMapper.readValue(file.toFile(), (TypeReference)typeRef);
        }
        catch (IOException e) {
            LOGGER.debug("Failed to read JSON file {}", (Object)file, (Object)e);
            return Map.of();
        }
    }
}

