/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bar.internal;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import org.apache.maven.Maven;
import org.apache.maven.execution.BuildSuccess;
import org.apache.maven.execution.BuildSummary;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.bonitasoft.bonita2bar.BuildBarException;
import org.bonitasoft.bonita2bar.MavenExecutor;
import org.bonitasoft.bpm.model.util.EnvironmentUtil;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ICallable;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.embedder.IMavenExecutionContext;

public class M2eMavenExecutor
implements MavenExecutor {
    public M2eMavenExecutor() {
        if (!EnvironmentUtil.isOSGi()) {
            throw new IllegalStateException("Use only in a P2 context with the org.eclipse.m2e.core plugin.");
        }
    }

    @Override
    public void execute(File pomFile, List<String> goals, Map<String, String> properties, List<String> activeProfiles, Supplier<String> errorMessageBase) throws BuildBarException {
        try {
            final IMaven maven = Optional.ofNullable(MavenPlugin.getMaven()).orElseGet(() -> {
                ResourcesPlugin.getPlugin();
                return Optional.ofNullable(MavenPlugin.getMaven()).orElseThrow(() -> new IllegalStateException("Maven is not available."));
            });
            IMavenExecutionContext ctx = maven.createExecutionContext();
            final MavenExecutionRequest request = ctx.getExecutionRequest();
            request.setGoals(goals);
            Properties userProperties = new Properties();
            properties.forEach(userProperties::setProperty);
            request.setUserProperties(userProperties);
            request.setActiveProfiles(activeProfiles);
            request.setPom(pomFile);
            MavenExecutionResult executionResult = (MavenExecutionResult)ctx.execute((ICallable)new ICallable<MavenExecutionResult>(){

                public MavenExecutionResult call(IMavenExecutionContext context, IProgressMonitor monitor) throws CoreException {
                    return ((Maven)maven.lookup(Maven.class)).execute(request);
                }
            }, null);
            BuildSummary buildSummary = executionResult.getBuildSummary(executionResult.getProject());
            if (!(buildSummary instanceof BuildSuccess)) {
                throw new BuildBarException(errorMessageBase.get(), (Throwable)executionResult.getExceptions().get(0));
            }
        }
        catch (CoreException e) {
            throw new BuildBarException(errorMessageBase.get(), e);
        }
    }
}

