/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bar.process.builder;

import org.bonitasoft.bonita2bar.process.builder.EngineDataBuilder;
import org.bonitasoft.bonita2bar.process.builder.GroovyConnectorConfigurationConverter;
import org.bonitasoft.bonita2bar.process.builder.MissingConnectorConfigurationException;
import org.bonitasoft.bonita2bar.process.expression.EngineExpressionUtil;
import org.bonitasoft.bonita2bar.process.expression.ExpressionHelper;
import org.bonitasoft.bpm.model.connectorconfiguration.ConnectorConfiguration;
import org.bonitasoft.bpm.model.connectorconfiguration.ConnectorParameter;
import org.bonitasoft.bpm.model.expression.AbstractExpression;
import org.bonitasoft.bpm.model.expression.Expression;
import org.bonitasoft.bpm.model.expression.Operation;
import org.bonitasoft.bpm.model.kpi.AbstractKPIBinding;
import org.bonitasoft.bpm.model.kpi.DatabaseKPIBinding;
import org.bonitasoft.bpm.model.parameter.Parameter;
import org.bonitasoft.bpm.model.process.AbstractProcess;
import org.bonitasoft.bpm.model.process.Actor;
import org.bonitasoft.bpm.model.process.BusinessObjectData;
import org.bonitasoft.bpm.model.process.ConnectableElement;
import org.bonitasoft.bpm.model.process.Connector;
import org.bonitasoft.bpm.model.process.Data;
import org.bonitasoft.bpm.model.process.DataAware;
import org.bonitasoft.bpm.model.process.Document;
import org.bonitasoft.bpm.model.process.Element;
import org.bonitasoft.bpm.model.process.MainProcess;
import org.bonitasoft.bpm.model.process.MultiInstantiable;
import org.bonitasoft.bpm.model.process.Pool;
import org.bonitasoft.bpm.model.process.SearchIndex;
import org.bonitasoft.bpm.model.process.Task;
import org.bonitasoft.bpm.model.process.util.ProcessSwitch;
import org.bonitasoft.bpm.model.util.IModelSearch;
import org.bonitasoft.engine.bpm.connector.ConnectorEvent;
import org.bonitasoft.engine.bpm.process.impl.ActorDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.ConnectorDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.DataDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.DescriptionBuilder;
import org.bonitasoft.engine.bpm.process.impl.FlowElementBuilder;
import org.bonitasoft.engine.bpm.process.impl.ProcessDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.UserTaskDefinitionBuilder;
import org.bonitasoft.engine.expression.ExpressionBuilder;
import org.bonitasoft.engine.expression.InvalidExpressionException;
import org.eclipse.emf.ecore.EObject;

public abstract class AbstractProcessBuilder
extends ProcessSwitch<Element> {
    protected IModelSearch modelSearch;
    public static final String DB_CONNECTOR_FOR_KPI_ID = "database-jdbc";
    public static final String DB_CONNECTOR_VERSION = "1.0.0";
    public static final String DB_DRIVER = "driver";
    public static final String DB_URL = "url";
    public static final String DB_QUERY = "script";
    public static final String DB_USER = "username";
    public static final String DB_PASSWORD = "password";
    private static final String SUFFIX_CONTEXT = "_ref";

    protected AbstractProcessBuilder(IModelSearch modelSearch) {
        this.modelSearch = modelSearch;
    }

    protected void addActors(ProcessDefinitionBuilder builder, AbstractProcess process) {
        for (Actor a : process.getActors()) {
            ActorDefinitionBuilder actorBuilder = builder.addActor(a.getName(), a.isInitiator());
            if (a.getDocumentation() == null) continue;
            actorBuilder.addDescription(a.getDocumentation());
        }
    }

    protected void addParameters(ProcessDefinitionBuilder builder, AbstractProcess process) {
        for (Parameter p : process.getParameters()) {
            String description = p.getDescription();
            builder.addParameter(p.getName(), p.getTypeClassname()).addDescription(description == null ? "" : description);
        }
    }

    protected void addSearchIndex(ProcessDefinitionBuilder builder, AbstractProcess process) throws InvalidExpressionException {
        if (process instanceof Pool) {
            Pool pool = (Pool)process;
            int i = 1;
            for (SearchIndex searchIndex : pool.getSearchIndexes()) {
                org.bonitasoft.engine.expression.Expression expr = EngineExpressionUtil.createExpression((AbstractExpression)searchIndex.getValue());
                if (searchIndex.getName().hasContent()) {
                    builder.setStringIndex(i, searchIndex.getName().getContent(), expr);
                }
                ++i;
            }
        }
    }

    protected void addConnector(FlowElementBuilder builder, ConnectableElement element) throws InvalidExpressionException {
        for (Connector connector : element.getConnectors()) {
            GroovyConnectorConfigurationConverter groovyConnectorConfigurationConverter = new GroovyConnectorConfigurationConverter();
            ConnectorConfiguration configuration = connector.getConfiguration();
            if (configuration == null) {
                throw new MissingConnectorConfigurationException(connector, element);
            }
            if (groovyConnectorConfigurationConverter.appliesTo(configuration)) {
                configuration = groovyConnectorConfigurationConverter.convert(connector.getConfiguration());
            }
            ConnectorDefinitionBuilder connectorBuilder = builder.addConnector(connector.getName(), connector.getDefinitionId(), connector.getDefinitionVersion(), ConnectorEvent.valueOf((String)connector.getEvent()));
            this.handleConnectorBehaviorOnFailure(connector, connectorBuilder);
            this.handleConnectorInputs(configuration, connectorBuilder);
            this.handleConnectorOutputs(connector, connectorBuilder);
        }
    }

    private void handleConnectorBehaviorOnFailure(Connector connector, ConnectorDefinitionBuilder connectorBuilder) {
        if (connector.isIgnoreErrors()) {
            connectorBuilder.ignoreError();
        } else if (connector.isThrowErrorEvent()) {
            connectorBuilder.throwErrorEventWhenFailed(connector.getNamedError());
        }
    }

    private void handleConnectorInputs(ConnectorConfiguration configuration, ConnectorDefinitionBuilder connectorBuilder) throws InvalidExpressionException {
        for (ConnectorParameter parameter : configuration.getParameters()) {
            org.bonitasoft.engine.expression.Expression inputExpression = EngineExpressionUtil.createExpression(parameter.getExpression());
            if (inputExpression == null) continue;
            connectorBuilder.addInput(parameter.getKey(), inputExpression);
        }
    }

    private void handleConnectorOutputs(Connector connector, ConnectorDefinitionBuilder connectorBuilder) throws InvalidExpressionException {
        for (Operation outputOperation : connector.getOutputs()) {
            if (outputOperation.getLeftOperand() == null || outputOperation.getLeftOperand().getContent() == null || outputOperation.getLeftOperand().getContent().isEmpty() || outputOperation.getRightOperand() == null || outputOperation.getRightOperand().getContent() == null) continue;
            connectorBuilder.addOutput(EngineExpressionUtil.createOperation(outputOperation));
        }
    }

    protected void addKPIBinding(FlowElementBuilder builder, ConnectableElement element) throws InvalidExpressionException {
        for (AbstractKPIBinding kpiBinding : element.getKpis()) {
            org.bonitasoft.engine.expression.Expression dbPasswordExpression;
            if (!(kpiBinding instanceof DatabaseKPIBinding)) continue;
            ConnectorDefinitionBuilder connectorBuilder = builder.addConnector(kpiBinding.getName(), DB_CONNECTOR_FOR_KPI_ID, DB_CONNECTOR_VERSION, ConnectorEvent.valueOf((String)kpiBinding.getEvent()));
            if (kpiBinding.isIgnoreError()) {
                connectorBuilder.ignoreError();
            }
            DatabaseKPIBinding dbKPI = (DatabaseKPIBinding)kpiBinding;
            connectorBuilder.addInput(DB_DRIVER, EngineExpressionUtil.createExpression((AbstractExpression)dbKPI.getDriverclassName()));
            connectorBuilder.addInput(DB_URL, EngineExpressionUtil.createExpression((AbstractExpression)dbKPI.getJdbcUrl()));
            connectorBuilder.addInput(DB_QUERY, EngineExpressionUtil.createExpression((AbstractExpression)dbKPI.getRequest()));
            org.bonitasoft.engine.expression.Expression dbUserExpression = EngineExpressionUtil.createExpression((AbstractExpression)dbKPI.getUser());
            if (dbUserExpression != null) {
                connectorBuilder.addInput(DB_USER, dbUserExpression);
            }
            if ((dbPasswordExpression = EngineExpressionUtil.createExpression((AbstractExpression)dbKPI.getPassword())) == null) continue;
            connectorBuilder.addInput(DB_PASSWORD, dbPasswordExpression);
        }
    }

    protected void addData(FlowElementBuilder dataContainerBuilder, DataAware dataAwareContainer) {
        for (Data data : dataAwareContainer.getData()) {
            EngineDataBuilder dataSwitch = this.getDataSwitch(dataContainerBuilder, data);
            DataDefinitionBuilder dataBuilder = (DataDefinitionBuilder)dataSwitch.doSwitch((EObject)data.getDataType());
            if (!data.isTransient() || dataBuilder == null) continue;
            dataBuilder.isTransient();
        }
    }

    protected EngineDataBuilder getDataSwitch(FlowElementBuilder dataContainerBuilder, Data data) {
        return new EngineDataBuilder(data, dataContainerBuilder);
    }

    protected void addDescription(DescriptionBuilder builder, String description) {
        if (description != null && !description.isEmpty()) {
            builder.addDescription(description);
        }
    }

    protected void addContext(Object contextBuilder, Task task) throws InvalidExpressionException {
        Pool pool = (Pool)this.modelSearch.getDirectParentOfType((EObject)task, Pool.class);
        this.addContext(contextBuilder, pool);
        this.addIteratorToContext(contextBuilder, task);
    }

    private void addIteratorToContext(Object contextBuilder, Task task) throws InvalidExpressionException {
        Expression iteratorExpression = task.getIteratorExpression();
        if (iteratorExpression != null && "MULTIINSTANCE_ITERATOR_TYPE".equals(iteratorExpression.getType()) && iteratorExpression.getName() != null && !iteratorExpression.getName().isEmpty() && task instanceof DataAware) {
            String referenceName = iteratorExpression.getName() + SUFFIX_CONTEXT;
            Data data = ExpressionHelper.dataFromIteratorExpression((MultiInstantiable)task, iteratorExpression, (MainProcess)this.modelSearch.getDirectParentOfType((EObject)task, MainProcess.class));
            if (data instanceof BusinessObjectData) {
                org.bonitasoft.engine.expression.Expression expression = AbstractProcessBuilder.createBusinessObjectDataReferenceExpression((BusinessObjectData)data);
                this.addContextEntry(contextBuilder, referenceName, expression);
            }
        }
    }

    protected void addContext(Object contextBuilder, Pool pool) throws InvalidExpressionException {
        this.addBusinessDataInContext(contextBuilder, pool);
        this.addDocumentInContext(contextBuilder, pool);
    }

    private void addDocumentInContext(Object contextBuilder, Pool pool) throws InvalidExpressionException {
        for (Document document : pool.getDocuments()) {
            String referenceName = document.getName() + SUFFIX_CONTEXT;
            org.bonitasoft.engine.expression.Expression documentReferenceExpression = AbstractProcessBuilder.createDocumentExpression(document);
            this.addContextEntry(contextBuilder, referenceName, documentReferenceExpression);
        }
    }

    private static org.bonitasoft.engine.expression.Expression createDocumentExpression(Document document) throws InvalidExpressionException {
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        return document.isMultiple() ? expressionBuilder.createDocumentListExpression(document.getName()) : expressionBuilder.createDocumentReferenceExpression(document.getName());
    }

    private static org.bonitasoft.engine.expression.Expression createBusinessObjectDataReferenceExpression(BusinessObjectData data) throws InvalidExpressionException {
        return new ExpressionBuilder().createBusinessDataReferenceExpression(data.getName());
    }

    private void addBusinessDataInContext(Object contextBuilder, Pool pool) throws InvalidExpressionException {
        for (Data data : pool.getData()) {
            if (!(data instanceof BusinessObjectData)) continue;
            String referenceName = data.getName() + SUFFIX_CONTEXT;
            org.bonitasoft.engine.expression.Expression referenceExpression = AbstractProcessBuilder.createBusinessObjectDataReferenceExpression((BusinessObjectData)data);
            this.addContextEntry(contextBuilder, referenceName, referenceExpression);
        }
    }

    private void addContextEntry(Object contextBuilder, String referenceName, org.bonitasoft.engine.expression.Expression referenceExpression) {
        if (contextBuilder instanceof UserTaskDefinitionBuilder) {
            ((UserTaskDefinitionBuilder)contextBuilder).addContextEntry(referenceName, referenceExpression);
        } else if (contextBuilder instanceof ProcessDefinitionBuilder) {
            ((ProcessDefinitionBuilder)contextBuilder).addContextEntry(referenceName, referenceExpression);
        }
    }
}

