/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bar.process.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.bonitasoft.bonita2bar.process.expression.ExpressionHelper;
import org.bonitasoft.bpm.model.expression.Expression;
import org.bonitasoft.bpm.model.expression.ExpressionFactory;
import org.bonitasoft.bpm.model.process.ContractInput;
import org.bonitasoft.engine.bpm.contract.FileInputValue;
import org.eclipse.emf.ecore.EObject;

public class DocumentGroovyScriptExpressionFactory {
    public Expression createSingleDocumentInitialContentScriptExpression(ContractInput input) {
        Expression groovyScriptExpression = DocumentGroovyScriptExpressionFactory.createGroovyScriptExpression(this.fileContractInputAccessorScript(input), FileInputValue.class.getName());
        groovyScriptExpression.setName("Single document initial value script");
        this.addInputDependency(input, groovyScriptExpression);
        return groovyScriptExpression;
    }

    private void addInputDependency(ContractInput input, Expression groovyScriptExpression) {
        groovyScriptExpression.getReferencedElements().add((Object)ExpressionHelper.createDependencyFromEObject((EObject)this.rootInput(input)));
    }

    public Expression createMultipleDocumentInitialContentScriptExpression(ContractInput input) {
        Expression groovyScriptExpression = DocumentGroovyScriptExpressionFactory.createGroovyScriptExpression(this.fileContractInputAccessorScript(input), List.class.getName());
        groovyScriptExpression.setName("Multiple document initial value script");
        this.addInputDependency(input, groovyScriptExpression);
        return groovyScriptExpression;
    }

    private String fileContractInputAccessorScript(ContractInput contractInput) {
        if (!(contractInput.eContainer() instanceof ContractInput) || Predicate.not(DocumentGroovyScriptExpressionFactory.withMultipleInHierarchy()).test((ContractInput)contractInput.eContainer())) {
            return DocumentGroovyScriptExpressionFactory.toAncestorNameList().apply(contractInput).stream().collect(Collectors.joining("."));
        }
        ContractInput parentInput = (ContractInput)contractInput.eContainer();
        StringBuilder scriptBuilder = new StringBuilder(DocumentGroovyScriptExpressionFactory.toAncestorNameList().apply(parentInput).stream().collect(Collectors.joining(".")));
        scriptBuilder.append(".collect{it.");
        scriptBuilder.append(contractInput.getName());
        scriptBuilder.append("}.flatten()");
        return scriptBuilder.toString();
    }

    private static Predicate<ContractInput> withMultipleInHierarchy() {
        return input -> {
            ContractInput current = input;
            while (current.eContainer() instanceof ContractInput) {
                if (current.isMultiple()) {
                    return true;
                }
                current = (ContractInput)current.eContainer();
            }
            return current.isMultiple();
        };
    }

    private ContractInput rootInput(ContractInput contractInput) {
        ContractInput root = contractInput;
        while (root.eContainer() instanceof ContractInput) {
            root = (ContractInput)root.eContainer();
        }
        return root;
    }

    private static Function<ContractInput, List<String>> toAncestorNameList() {
        return input -> {
            ArrayList<String> ancestors = new ArrayList<String>();
            ContractInput current = input;
            while (current instanceof ContractInput) {
                ancestors.add(current.getName());
                current = current.eContainer();
            }
            Collections.reverse(ancestors);
            return ancestors;
        };
    }

    private static Expression createGroovyScriptExpression(String expressionContent, String returnType) {
        Expression exp = ExpressionFactory.eINSTANCE.createExpression();
        exp.setName("ExpressionForEvaluation");
        exp.setInterpreter("GROOVY");
        exp.setType("TYPE_READ_ONLY_SCRIPT");
        exp.setContent(expressionContent);
        exp.setReturnType(returnType);
        return exp;
    }
}

