/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bar.process.builder;

import org.bonitasoft.bonita2bar.process.builder.AbstractProcessBuilder;
import org.bonitasoft.bonita2bar.process.builder.BuildProcessDefinitionException;
import org.bonitasoft.bonita2bar.process.builder.DocumentEngineDefinitionBuilder;
import org.bonitasoft.bonita2bar.process.builder.ProcessBuilderException;
import org.bonitasoft.bonita2bar.process.builder.ProcessContractEngineBuilder;
import org.bonitasoft.bpm.model.process.AbstractProcess;
import org.bonitasoft.bpm.model.process.ConnectableElement;
import org.bonitasoft.bpm.model.process.DataAware;
import org.bonitasoft.bpm.model.process.Document;
import org.bonitasoft.bpm.model.process.Element;
import org.bonitasoft.bpm.model.process.Pool;
import org.bonitasoft.bpm.model.util.IModelSearch;
import org.bonitasoft.engine.bpm.process.impl.FlowElementBuilder;
import org.bonitasoft.engine.bpm.process.impl.ProcessDefinitionBuilder;
import org.bonitasoft.engine.expression.InvalidExpressionException;
import org.eclipse.emf.ecore.EObject;

public class EngineProcessBuilder
extends AbstractProcessBuilder {
    protected final ProcessDefinitionBuilder builder;
    private ProcessContractEngineBuilder processContractBuilder;
    private DocumentEngineDefinitionBuilder documentBuilder;

    public EngineProcessBuilder(ProcessDefinitionBuilder processBuilder, ProcessContractEngineBuilder processContractBuilder, DocumentEngineDefinitionBuilder documentBuilder, IModelSearch modelSearch) {
        super(modelSearch);
        this.builder = processBuilder;
        this.processContractBuilder = processContractBuilder;
        this.documentBuilder = documentBuilder;
    }

    public Element casePool(Pool pool) {
        if (pool.getDisplayName() != null) {
            this.builder.addDisplayName(pool.getDisplayName());
        }
        try {
            this.addDocuments(this.builder, pool);
            this.addActors(this.builder, (AbstractProcess)pool);
            this.addData((FlowElementBuilder)this.builder, (DataAware)pool);
            this.addParameters(this.builder, (AbstractProcess)pool);
            this.addSearchIndex(this.builder, (AbstractProcess)pool);
            this.addConnector((FlowElementBuilder)this.builder, (ConnectableElement)pool);
            this.addKPIBinding((FlowElementBuilder)this.builder, (ConnectableElement)pool);
            this.addInstantiationContract(this.builder, pool);
            this.addContext((Object)this.builder, pool);
        }
        catch (InvalidExpressionException e) {
            throw new ProcessBuilderException(e);
        }
        return pool;
    }

    private void addInstantiationContract(ProcessDefinitionBuilder builder, Pool pool) {
        if (pool != null && pool.getContract() != null) {
            this.processContractBuilder.setEngineBuilder(builder);
            try {
                this.processContractBuilder.build((EObject)pool.getContract());
            }
            catch (BuildProcessDefinitionException e) {
                throw new ProcessBuilderException(e);
            }
        }
    }

    private void addDocuments(ProcessDefinitionBuilder builder, Pool pool) {
        if (pool != null) {
            for (Document document : pool.getDocuments()) {
                try {
                    this.documentBuilder.setEngineBuilder(builder);
                    this.documentBuilder.build((EObject)document);
                }
                catch (BuildProcessDefinitionException e) {
                    throw new ProcessBuilderException("Failed to export document definition for " + pool.getName(), e);
                }
            }
        }
    }

    public ProcessDefinitionBuilder getProcessBuilder() {
        return this.builder;
    }
}

