/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bar.process.builder;

import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.bonitasoft.bonita2bar.process.expression.ExpressionHelper;
import org.bonitasoft.bpm.model.connectorconfiguration.ConnectorConfiguration;
import org.bonitasoft.bpm.model.connectorconfiguration.ConnectorParameter;
import org.bonitasoft.bpm.model.expression.AbstractExpression;
import org.bonitasoft.bpm.model.expression.Expression;
import org.bonitasoft.bpm.model.expression.ExpressionFactory;
import org.bonitasoft.bpm.model.expression.ListExpression;
import org.bonitasoft.bpm.model.expression.TableExpression;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class GroovyConnectorConfigurationConverter {
    private static final String SCRIPTING_GROOVY_SCRIPT_DEF_ID = "scripting-groovy-script";
    private static final String VARIABLES_INPUT = "variables";
    private static final String SCRIPT_INPUT = "script";
    private static final String FAKE_SCRIPT_EXPRESSION = "fakeScriptExpression";

    public ConnectorConfiguration convert(ConnectorConfiguration connectorConfiguration) {
        this.checkConnectorConfiguration(connectorConfiguration);
        ConnectorConfiguration configuration = (ConnectorConfiguration)EcoreUtil.copy((EObject)connectorConfiguration);
        Expression fakeExpression = this.getFakeExpression(configuration);
        configuration.getParameters().stream().filter(GroovyConnectorConfigurationConverter.withInputName(SCRIPT_INPUT)).findFirst().ifPresent(param -> param.setExpression((AbstractExpression)this.createConstantScriptExpression(fakeExpression)));
        configuration.getParameters().stream().filter(GroovyConnectorConfigurationConverter.withInputName(VARIABLES_INPUT)).findFirst().ifPresent(param -> param.setExpression((AbstractExpression)this.createVariableExpression(fakeExpression)));
        configuration.getParameters().removeIf(GroovyConnectorConfigurationConverter.withInputName(FAKE_SCRIPT_EXPRESSION));
        return configuration;
    }

    static Predicate<ConnectorParameter> withInputName(String name) {
        return input -> Objects.equals(name, input.getKey());
    }

    private Expression createConstantScriptExpression(Expression fakeExpression) {
        Expression scriptExpression = ExpressionHelper.createConstantExpression(fakeExpression.getContent(), String.class.getName());
        scriptExpression.setName(fakeExpression.getName());
        return scriptExpression;
    }

    private void checkConnectorConfiguration(ConnectorConfiguration connectorConfig) {
        Objects.requireNonNull(connectorConfig);
        if (!connectorConfig.getDefinitionId().equals(SCRIPTING_GROOVY_SCRIPT_DEF_ID)) {
            throw new IllegalArgumentException();
        }
        Set keys = connectorConfig.getParameters().stream().map(ConnectorParameter::getKey).collect(Collectors.toSet());
        if (!keys.containsAll(Arrays.asList(SCRIPT_INPUT, FAKE_SCRIPT_EXPRESSION, VARIABLES_INPUT))) {
            throw new IllegalStateException();
        }
    }

    private TableExpression createVariableExpression(Expression fakeExpression) {
        TableExpression variableExpression = ExpressionFactory.eINSTANCE.createTableExpression();
        for (EObject dep : fakeExpression.getReferencedElements()) {
            Expression depValueExpression = ExpressionHelper.createExpressionFromEObject(dep);
            if (depValueExpression == null) continue;
            ListExpression depLine = ExpressionFactory.eINSTANCE.createListExpression();
            Expression depNameExpression = ExpressionHelper.createConstantExpression(depValueExpression.getName(), String.class.getName());
            EList expressions = depLine.getExpressions();
            expressions.addAll(Arrays.asList(depNameExpression, depValueExpression));
            variableExpression.getExpressions().add((Object)depLine);
        }
        return variableExpression;
    }

    private Expression getFakeExpression(ConnectorConfiguration configuration) {
        for (ConnectorParameter param : configuration.getParameters()) {
            AbstractExpression expression;
            if (!FAKE_SCRIPT_EXPRESSION.equals(param.getKey()) || !((expression = param.getExpression()) instanceof Expression)) continue;
            return (Expression)expression;
        }
        return null;
    }

    public boolean appliesTo(ConnectorConfiguration configuration) {
        return configuration != null && SCRIPTING_GROOVY_SCRIPT_DEF_ID.equals(configuration.getDefinitionId());
    }
}

