/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bar.process.expression;

import java.util.ArrayList;
import java.util.List;
import org.bonitasoft.bonita2bar.process.expression.ExpressionHelper;
import org.bonitasoft.bpm.model.expression.Expression;
import org.bonitasoft.bpm.model.expression.ExpressionFactory;
import org.bonitasoft.bpm.model.parameter.Parameter;
import org.bonitasoft.bpm.model.process.Data;
import org.bonitasoft.bpm.model.process.decision.DecisionTable;
import org.bonitasoft.bpm.model.process.decision.DecisionTableAction;
import org.bonitasoft.bpm.model.process.decision.DecisionTableLine;
import org.bonitasoft.bpm.model.process.decision.transitions.TakeTransitionAction;
import org.eclipse.emf.ecore.EObject;

public class DecisionTableUtil {
    private static final String CONDITION_SEPARATOR = " && ";

    private DecisionTableUtil() {
    }

    public static Expression toGroovyScriptExpression(DecisionTable decisionTable) {
        StringBuilder builder = new StringBuilder();
        ArrayList<Object> listReferencedElements = new ArrayList<Object>();
        for (DecisionTableLine line : decisionTable.getLines()) {
            DecisionTableUtil.appendConditions(builder, listReferencedElements, line);
            builder.append(") { ");
            builder.append(DecisionTableUtil.toGroovyAction(line.getAction()));
            builder.append(";}");
            builder.append("\n");
        }
        builder.append(DecisionTableUtil.toGroovyAction(decisionTable.getDefaultAction()));
        builder.append(";");
        String script = builder.toString();
        Expression exp = ExpressionFactory.eINSTANCE.createExpression();
        exp.setType("TYPE_READ_ONLY_SCRIPT");
        exp.setInterpreter("GROOVY");
        exp.setContent(script);
        exp.setName("Descision Table Script");
        exp.setReturnType(Boolean.class.getName());
        DecisionTableUtil.addReferencedElements(listReferencedElements, exp);
        return exp;
    }

    private static void addReferencedElements(List<Object> listReferencedElements, Expression exp) {
        for (Object ref : listReferencedElements) {
            if (ref instanceof Data) {
                DecisionTableUtil.addData(exp, ref);
                continue;
            }
            if (ref instanceof Parameter) {
                DecisionTableUtil.addParameter(exp, ref);
                continue;
            }
            throw new IllegalStateException("Reference element not supported in decision table condition: " + String.valueOf(ref));
        }
    }

    private static void addParameter(Expression exp, Object ref) {
        Parameter parameter = (Parameter)ref;
        String parameterName = parameter.getName();
        boolean addRef = true;
        for (EObject obj : exp.getReferencedElements()) {
            Parameter parameterObj;
            String parameterObjName;
            Data dataObj;
            String dataObjName;
            if (obj instanceof Data && (dataObjName = (dataObj = (Data)obj).getName()).equals(parameterName)) {
                addRef = false;
            }
            if (!(obj instanceof Parameter) || !(parameterObjName = (parameterObj = (Parameter)obj).getName()).equals(parameterName)) continue;
            addRef = false;
        }
        if (addRef) {
            exp.getReferencedElements().add((Object)((EObject)ref));
        }
    }

    private static void addData(Expression exp, Object ref) {
        Data data = (Data)ref;
        String dataName = data.getName();
        boolean addRef = true;
        for (EObject obj : exp.getReferencedElements()) {
            Parameter parameterObj;
            String parameterObjName;
            Data dataObj;
            String dataObjName;
            if (obj instanceof Data && (dataObjName = (dataObj = (Data)obj).getName()).equals(dataName)) {
                addRef = false;
            }
            if (!(obj instanceof Parameter) || !(parameterObjName = (parameterObj = (Parameter)obj).getName()).equals(dataName)) continue;
            addRef = false;
        }
        if (addRef) {
            exp.getReferencedElements().add((Object)((EObject)ref));
        }
    }

    private static void appendConditions(StringBuilder builder, List<Object> listReferencedElements, DecisionTableLine line) {
        builder.append(" if (");
        for (Expression condition : line.getConditions()) {
            builder.append("(");
            builder.append(DecisionTableUtil.toGroovyCondition(condition));
            builder.append(")");
            builder.append(CONDITION_SEPARATOR);
            for (EObject dep : condition.getReferencedElements()) {
                listReferencedElements.add(ExpressionHelper.createDependencyFromEObject(dep));
            }
        }
        builder.delete(builder.length() - CONDITION_SEPARATOR.length(), builder.length());
    }

    private static String toGroovyAction(DecisionTableAction defaultAction) {
        return defaultAction instanceof TakeTransitionAction ? "return " + ((TakeTransitionAction)defaultAction).isTakeTransition() : "WRONG_ACTION";
    }

    private static String toGroovyCondition(Expression condition) {
        return condition.getContent();
    }
}

