/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bar.process.pomgen;

import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class ProcessPom
implements Closeable {
    Path folderPath;

    ProcessPom(Path folderPath) {
        this.folderPath = folderPath;
    }

    public Model readPom() throws IOException, XmlPullParserException {
        File pom = this.folderPath.resolve("pom.xml").toFile();
        if (!pom.exists()) {
            throw new IllegalStateException("pom.xml not found in " + String.valueOf(this.folderPath));
        }
        MavenXpp3Reader reader = new MavenXpp3Reader();
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileReader fileReader = new FileReader(pom);){
            Model pomModel = reader.read((Reader)fileReader);
            pomModel.setPomFile(pom);
            return pomModel;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void writePom(Model model) throws IOException {
        File pom = this.folderPath.resolve("pom.xml").toFile();
        MavenXpp3Writer writer = new MavenXpp3Writer();
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileWriter fileWriter = new FileWriter(pom);){
            writer.write((Writer)fileWriter, model);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.folderPath != null && Files.exists(this.folderPath, new LinkOption[0])) {
            FileUtils.deleteDirectory((File)this.folderPath.toFile());
        }
    }
}

