/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bar.process.pomgen;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Model;
import org.apache.maven.project.MavenProject;
import org.bonitasoft.bonita2bar.ConnectorImplementationRegistry;
import org.bonitasoft.bonita2bar.process.pomgen.ProcessPom;
import org.bonitasoft.bpm.connector.model.implementation.ConnectorImplementation;
import org.bonitasoft.bpm.model.process.Connector;
import org.bonitasoft.bpm.model.process.Pool;

public class ProcessPomGenerator {
    private MavenProject applicationProject;
    private ConnectorImplementationRegistry connectorImplementationRegistry;

    private ProcessPomGenerator() {
    }

    public static ProcessPomGenerator create(MavenProject applicationProject, ConnectorImplementationRegistry connectorImplementationRegistry) {
        ProcessPomGenerator gen = new ProcessPomGenerator();
        gen.applicationProject = applicationProject;
        gen.connectorImplementationRegistry = connectorImplementationRegistry;
        return gen;
    }

    public <R, E extends Exception> R withGeneratedPom(Pool process, ProcessPomConsumer<R, E> consumer) throws IOException, E {
        Throwable throwable = null;
        Object var4_5 = null;
        try (ProcessPom pomAccess = this.generatePom(process);){
            return consumer.consume(pomAccess);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private ProcessPom generatePom(Pool process) throws IOException {
        String target = Optional.ofNullable(this.applicationProject.getBuild()).map(BuildBase::getDirectory).filter(Objects::nonNull).orElseGet(() -> this.applicationProject.getBasedir().toPath().resolve("target").toString());
        Files.createDirectories(Path.of(target, new String[0]), new FileAttribute[0]);
        String notNormalizedName = String.format("%s--%s", process.getName(), process.getVersion());
        String folderName = notNormalizedName.toLowerCase().replaceAll("[^a-z0-9\\-]", "-");
        Path tempFolderPath = Files.createTempDirectory(Path.of(target, new String[0]), folderName + "_", new FileAttribute[0]);
        ProcessPom pomAccess = new ProcessPom(tempFolderPath);
        Model model = this.applicationProject.getModel().clone();
        model.setArtifactId(folderName);
        Optional.ofNullable(model.getParent().getRelativePath()).ifPresent(relPath -> {
            Path fixedPath = tempFolderPath.relativize(this.applicationProject.getBasedir().toPath().resolve(Path.of(relPath, new String[0])));
            model.getParent().setRelativePath(fixedPath.toString());
        });
        this.filterUnusedConnectorDependencies(model, process);
        pomAccess.writePom(model);
        return pomAccess;
    }

    private void filterUnusedConnectorDependencies(Model model, Pool process) {
        ArrayList processUsedConnectors = new ArrayList();
        process.eAllContents().forEachRemaining(obj -> {
            if (obj instanceof Connector) {
                Connector c = (Connector)obj;
                processUsedConnectors.add(c);
            }
        });
        model.getDependencies().removeIf(dep -> {
            boolean isConnectorDep;
            List<ConnectorImplementation> connectorImplementations = this.connectorImplementationRegistry.findAll(ConnectorImplementationRegistry.ArtifactInfo.matchesDep(dep));
            boolean bl = isConnectorDep = !connectorImplementations.isEmpty();
            return isConnectorDep && connectorImplementations.stream().allMatch(connImpl -> {
                Predicate<Connector> matchesImpl = connDef -> connDef.getDefinitionId().equals(connImpl.getDefinitionId()) && connDef.getDefinitionVersion().equals(connImpl.getDefinitionVersion());
                return processUsedConnectors.stream().noneMatch(matchesImpl);
            });
        });
    }

    @FunctionalInterface
    public static interface ProcessPomConsumer<R, E extends Exception> {
        public R consume(ProcessPom var1) throws E;
    }
}

