/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bar.resources;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bonitasoft.bonita2bar.BarArtifactProvider;
import org.bonitasoft.bonita2bar.BuildBarException;
import org.bonitasoft.bpm.model.configuration.Configuration;
import org.bonitasoft.bpm.model.process.AbstractProcess;
import org.bonitasoft.bpm.model.process.Pool;
import org.bonitasoft.engine.bpm.bar.BarResource;
import org.bonitasoft.engine.bpm.bar.BusinessArchiveBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdditionalResourcesArtifactProvider
implements BarArtifactProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdditionalResourcesArtifactProvider.class);
    private static final String COMMON_FOLDER = "_common";
    private Path resourcesFolder;

    public AdditionalResourcesArtifactProvider(Path resourcesFolder) {
        this.resourcesFolder = resourcesFolder;
    }

    @Override
    public void build(BusinessArchiveBuilder builder, Pool process, Configuration configuration) throws BuildBarException {
        try {
            File processFolder;
            File commonFolder = this.resourcesFolder.resolve(COMMON_FOLDER).toFile();
            if (commonFolder.exists()) {
                this.addFolderInBarResources(builder, commonFolder, (AbstractProcess)process);
            }
            if ((processFolder = this.resourcesFolder.resolve(process.getName()).toFile()).exists()) {
                this.addFolderInBarResources(builder, processFolder, (AbstractProcess)process);
            }
            if ((processFolder = this.resourcesFolder.resolve(String.format("%s-%s", process.getName(), process.getVersion())).toFile()).exists()) {
                this.addFolderInBarResources(builder, processFolder, (AbstractProcess)process);
            }
        }
        catch (IOException e) {
            String message = String.format("Failed to add resource folder %s in bar %s-%s.bar.", this.resourcesFolder.toString(), process.getName(), process.getVersion());
            throw new BuildBarException(message, e);
        }
    }

    private void addFolderInBarResources(BusinessArchiveBuilder builder, File folder, AbstractProcess process) throws IOException {
        Path folderPath = folder.toPath();
        LOGGER.info("Adding resource folder '{}' in bar.", (Object)folder.getPath());
        Throwable throwable = null;
        Object var6_7 = null;
        try (Stream<Path> files = Files.walk(folderPath, new FileVisitOption[0]);){
            for (Path resourcePath : files.collect(Collectors.toList())) {
                if (!resourcePath.toFile().isFile()) continue;
                Path barPath = folderPath.relativize(resourcePath);
                byte[] content = Files.readAllBytes(resourcePath);
                if (content.length > 0) {
                    builder.addExternalResource(new BarResource(barPath.toString(), content));
                    LOGGER.debug("Resource '{}' has been added to {}--{}.bar.", new Object[]{resourcePath, process.getName(), process.getVersion()});
                    continue;
                }
                LOGGER.warn("Resource '{}' is empty and has not been added to {}--{}.bar.", new Object[]{resourcePath, process.getName(), process.getVersion()});
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

