/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bar.resources;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import org.bonitasoft.bonita2bar.BarArtifactProvider;
import org.bonitasoft.bonita2bar.BarBuilder;
import org.bonitasoft.bonita2bar.BuildBarException;
import org.bonitasoft.bonita2bar.ProcessRegistry;
import org.bonitasoft.bonita2bpmn.extension.BonitaModelExporterImpl;
import org.bonitasoft.bonita2bpmn.extension.IBonitaModelExporter;
import org.bonitasoft.bonita2bpmn.transfo.BonitaToBPMNExporter;
import org.bonitasoft.bonita2bpmn.transfo.ConnectorTransformationXSLProvider;
import org.bonitasoft.bpm.model.configuration.Configuration;
import org.bonitasoft.bpm.model.process.Pool;
import org.bonitasoft.bpm.model.util.IModelSearch;
import org.bonitasoft.bpm.model.util.ModelSearch;
import org.bonitasoft.engine.bpm.bar.BarResource;
import org.bonitasoft.engine.bpm.bar.BusinessArchiveBuilder;
import org.eclipse.emf.ecore.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BPMN2ArtifactProvider
implements BarArtifactProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(BPMN2ArtifactProvider.class);
    private ProcessRegistry processRegistry;
    private Path workingDirectory;

    public BPMN2ArtifactProvider(ProcessRegistry processRegistry, Path workingDirectory) {
        this.processRegistry = processRegistry;
        this.workingDirectory = workingDirectory;
    }

    @Override
    public void build(BusinessArchiveBuilder builder, Pool process, Configuration configuration) throws BuildBarException {
        LOGGER.info("Adding BPMN2 model...");
        ModelSearch modelSearch = new ModelSearch(this.processRegistry::getProcesses);
        BonitaToBPMNExporter bonitaToBPMNExporter = new BonitaToBPMNExporter();
        Path destFile = null;
        try {
            try {
                if (!Files.exists(this.workingDirectory, new LinkOption[0])) {
                    Files.createDirectories(this.workingDirectory, new FileAttribute[0]);
                }
                destFile = Files.createTempFile(this.workingDirectory, "process", ".bpmn", new FileAttribute[0]);
                Resource resource = process.eResource();
                if (resource != null) {
                    bonitaToBPMNExporter.export((IBonitaModelExporter)new BonitaModelExporterImpl(resource, (IModelSearch)modelSearch), (IModelSearch)modelSearch, Collections::emptyList, destFile.toFile(), ConnectorTransformationXSLProvider.DEFAULT, BarBuilder.builderVersion());
                    builder.addExternalResource(new BarResource("process.bpmn", Files.readAllBytes(destFile)));
                } else {
                    LOGGER.warn("Process {} ({}) is not contained in a Resource. BPMN file will not be added to the bar.", (Object)process.getName(), (Object)process.getVersion());
                }
            }
            catch (IOException e) {
                throw new BuildBarException("Failed to build bpmn2 file", e);
            }
        }
        catch (Throwable throwable) {
            if (destFile != null) {
                try {
                    Files.deleteIfExists(destFile);
                }
                catch (IOException e) {
                    LOGGER.warn("Failed to delete temporary file {}", destFile);
                }
            }
            throw throwable;
        }
        if (destFile != null) {
            try {
                Files.deleteIfExists(destFile);
            }
            catch (IOException e) {
                LOGGER.warn("Failed to delete temporary file {}", (Object)destFile);
            }
        }
    }
}

