/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bar.resources;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.bonitasoft.bonita2bar.BarArtifactProvider;
import org.bonitasoft.bonita2bar.BuildBarException;
import org.bonitasoft.bpm.model.configuration.Configuration;
import org.bonitasoft.bpm.model.process.Document;
import org.bonitasoft.bpm.model.process.DocumentType;
import org.bonitasoft.bpm.model.process.Pool;
import org.bonitasoft.engine.bpm.bar.BarResource;
import org.bonitasoft.engine.bpm.bar.BusinessArchiveBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentArtifactProvider
implements BarArtifactProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentArtifactProvider.class);
    private Path attachmentFolder;

    public DocumentArtifactProvider(Path attachmentFolder) {
        this.attachmentFolder = attachmentFolder;
    }

    @Override
    public void build(BusinessArchiveBuilder builder, Pool process, Configuration configuration) throws BuildBarException {
        for (Document document : process.getDocuments()) {
            File attachment;
            String attachmentName;
            if (!document.getDocumentType().equals((Object)DocumentType.INTERNAL) || (attachmentName = document.getDefaultValueIdOfDocumentStore()) == null || !(attachment = this.attachmentFolder.resolve(attachmentName).toFile()).exists()) continue;
            try {
                LOGGER.info("Adding {} document...", (Object)attachment.getName());
                builder.addDocumentResource(new BarResource(attachment.getName(), Files.readAllBytes(attachment.toPath())));
            }
            catch (IOException e) {
                String message = String.format("Failed to add document %s in bar %s-%s.bar", attachmentName, process.getName(), process.getVersion());
                throw new BuildBarException(message, e);
            }
        }
    }
}

