/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bar;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.bonitasoft.bonita2bar.BarArtifactProvider;
import org.bonitasoft.bonita2bar.BuildBarException;
import org.bonitasoft.bonita2bar.BuildResult;
import org.bonitasoft.bonita2bar.ProcessRegistry;
import org.bonitasoft.bonita2bar.configuration.EnvironmentConfigurationBuilder;
import org.bonitasoft.bonita2bar.configuration.model.ParametersConfiguration;
import org.bonitasoft.bonita2bar.process.pomgen.ProcessPomGenerator;
import org.bonitasoft.bpm.model.configuration.Configuration;
import org.bonitasoft.bpm.model.configuration.ConfigurationFactory;
import org.bonitasoft.bpm.model.process.Pool;
import org.bonitasoft.bpm.model.util.ModelLoader;
import org.bonitasoft.engine.bpm.bar.BusinessArchiveBuilder;
import org.bonitasoft.engine.bpm.bar.InvalidBusinessArchiveFormatException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BarBuilder {
    public static final String LOCAL_ENVIRONMENT = "Local";
    private static final Logger LOGGER = LoggerFactory.getLogger(BarBuilder.class);
    private List<BarArtifactProvider> providers = new ArrayList<BarArtifactProvider>();
    private Path localConfiguration;
    private ProcessRegistry processRegistry;
    private ParametersConfiguration parametersConfiguration;
    private Path workdir;
    private ProcessPomGenerator processPomGenerator;
    private BuildResult buildResult;

    BarBuilder(ProcessRegistry processRegistry, Path localConfiguration, ParametersConfiguration parametersConfiguration, Path workdir, ProcessPomGenerator processPomGenerator) {
        this.processRegistry = processRegistry;
        this.localConfiguration = localConfiguration;
        this.parametersConfiguration = parametersConfiguration;
        this.workdir = workdir;
        this.processPomGenerator = processPomGenerator;
    }

    public BuildResult buildAll(String environment) throws BuildBarException {
        this.buildResult = new BuildResult(environment, this.parametersConfiguration, this.workdir);
        for (Pool process : this.processRegistry.getProcesses()) {
            try {
                this.buildResult.add(this.buildBar(process, this.getConfiguration(process, environment)));
            }
            catch (IOException e) {
                throw new BuildBarException(e);
            }
        }
        return this.buildResult;
    }

    public BuildResult buildConfiguration(String environment) throws IOException {
        this.buildResult = new BuildResult(environment, this.parametersConfiguration, this.workdir);
        for (Pool process : this.processRegistry.getProcesses()) {
            this.buildResult.add(this.configureProcess(process, environment));
        }
        return this.buildResult;
    }

    public BuildResult build(String name, String version, String environment) throws BuildBarException {
        if (this.buildResult == null) {
            this.buildResult = new BuildResult(environment, this.parametersConfiguration, this.workdir);
        }
        Pool process = this.processRegistry.getProcess(name, version).orElseThrow(() -> new IllegalArgumentException(String.format("No process found in registry for %s (%s)", name, version)));
        try {
            BuildResult result = this.buildBar(process, this.getConfiguration(process, environment));
            this.buildResult.add(result);
            return result;
        }
        catch (IOException e) {
            throw new BuildBarException(e);
        }
    }

    public BuildResult build(Pool process, String environment) throws BuildBarException {
        if (this.buildResult == null) {
            this.buildResult = new BuildResult(environment, this.parametersConfiguration, this.workdir);
        }
        try {
            BuildResult result = this.buildBar(process, this.getConfiguration(process, environment));
            this.buildResult.add(result);
            return result;
        }
        catch (IOException e) {
            throw new BuildBarException(e);
        }
    }

    public BuildResult build(Pool process, Configuration configuration) throws BuildBarException {
        if (this.buildResult == null) {
            this.buildResult = new BuildResult(configuration.getName(), this.parametersConfiguration, this.workdir);
        }
        BuildResult result = this.buildBar(process, configuration);
        this.buildResult.add(result);
        return result;
    }

    public BuildResult getBuildResult() {
        return this.buildResult;
    }

    private BuildResult buildBar(Pool process, Configuration configuration) throws BuildBarException {
        try {
            return this.processPomGenerator.withGeneratedPom(process, pomAccess -> {
                try {
                    if (process.eResource() != null && process.eResource().getURI() != null) {
                        String resourceName = URI.decode((String)process.eResource().getURI().lastSegment());
                        LOGGER.info("Building {}-{} ({})...", new Object[]{process.getName(), process.getVersion(), resourceName});
                    } else {
                        LOGGER.info("Building {}-{}...", (Object)process.getName(), (Object)process.getVersion());
                    }
                    BusinessArchiveBuilder barBuilder = this.createBusinessArchiveBuilder();
                    EnvironmentConfigurationBuilder confBuilder = this.createEnvironmentConfigurationBuilder(process.getName(), process.getVersion(), configuration.getName());
                    for (BarArtifactProvider provider : this.providers) {
                        provider.build(barBuilder, process, pomAccess, configuration);
                        provider.configure(confBuilder, configuration, process);
                    }
                    BuildResult result = new BuildResult(configuration.getName() == null ? LOCAL_ENVIRONMENT : configuration.getName(), this.parametersConfiguration, this.workdir);
                    result.addBusinessArchive(barBuilder.done());
                    result.addConfiguration(confBuilder.done());
                    return result;
                }
                catch (InvalidBusinessArchiveFormatException e) {
                    String errorMessage = String.format("%s-%s build failed", process.getName(), process.getVersion());
                    throw new BuildBarException(errorMessage, e);
                }
            });
        }
        catch (IOException e) {
            String errorMessage = String.format("%s-%s build failed", process.getName(), process.getVersion());
            throw new BuildBarException(errorMessage, e);
        }
    }

    private BuildResult configureProcess(Pool process, String environment) throws IOException {
        LOGGER.info("Configure {} ({})...", (Object)process.getName(), (Object)process.getVersion());
        EnvironmentConfigurationBuilder confBuilder = this.createEnvironmentConfigurationBuilder(process.getName(), process.getVersion(), environment);
        Configuration configuration = this.getConfiguration(process, environment);
        for (BarArtifactProvider provider : this.providers) {
            provider.configure(confBuilder, configuration, process);
        }
        BuildResult result = new BuildResult(environment, this.parametersConfiguration, this.workdir);
        result.addConfiguration(confBuilder.done());
        return result;
    }

    private static Configuration emptyConfiguration(String environment) {
        Configuration defaultConfiguration = ConfigurationFactory.eINSTANCE.createConfiguration();
        defaultConfiguration.setName(environment != null ? environment : LOCAL_ENVIRONMENT);
        return defaultConfiguration;
    }

    private EnvironmentConfigurationBuilder createEnvironmentConfigurationBuilder(String processName, String processVersion, String environment) {
        return new EnvironmentConfigurationBuilder(processName, processVersion, environment == null ? LOCAL_ENVIRONMENT : environment);
    }

    protected BusinessArchiveBuilder createBusinessArchiveBuilder() {
        return new BusinessArchiveBuilder().createNewBusinessArchive();
    }

    Configuration getConfiguration(Pool process, String environment) throws IOException {
        String uuid = BarBuilder.getEObjectID((EObject)process);
        if (LOCAL_ENVIRONMENT.equalsIgnoreCase(environment) || environment == null) {
            File configurationFolder = this.localConfiguration.toFile();
            File confFile = new File(configurationFolder, String.format("%s.conf", uuid));
            if (!confFile.exists()) {
                this.warnConfigurationNotFound(process, environment);
                return BarBuilder.emptyConfiguration(environment);
            }
            Resource resource = ModelLoader.create().withPolicy(this.processRegistry.getMigrationPolicy()).loadModel(URI.createFileURI((String)confFile.getAbsolutePath()));
            if (resource.getContents().isEmpty() || !(resource.getContents().get(0) instanceof Configuration)) {
                throw new IOException(String.format("No Configuration found in file %s", confFile.getAbsolutePath()));
            }
            EList contents = resource.getContents();
            return (Configuration)contents.get(0);
        }
        return process.getConfigurations().stream().filter(conf -> Objects.equals(this.toLowerCase(conf.getName()), this.toLowerCase(environment))).findFirst().orElseGet(() -> {
            this.warnConfigurationNotFound(process, environment);
            return BarBuilder.emptyConfiguration(environment);
        });
    }

    private void warnConfigurationNotFound(Pool process, String environment) {
        LOGGER.warn("{} configuration not found for {}-{}.", new Object[]{environment, process.getName(), process.getVersion()});
    }

    private String toLowerCase(String name) {
        return name != null ? name.toLowerCase() : name;
    }

    private static String getEObjectID(EObject eObject) {
        if (eObject == null) {
            return null;
        }
        Resource eResource = eObject.eResource();
        if (eResource != null) {
            return eResource.getURIFragment(eObject);
        }
        return null;
    }

    public void register(BarArtifactProvider barArtifactProvider) {
        this.providers.add(barArtifactProvider);
    }

    public static String builderVersion() {
        URL url = BarBuilder.class.getResource("info.properties");
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream is = url.openStream();){
                Properties info = new Properties();
                info.load(is);
                return info.getProperty("version");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            return null;
        }
    }
}

