/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bar;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.bonitasoft.bonita2bar.configuration.ConfigurationArchiveBuilder;
import org.bonitasoft.bonita2bar.configuration.EnvironmentConfiguration;
import org.bonitasoft.bonita2bar.configuration.model.ParametersConfiguration;
import org.bonitasoft.bpm.model.util.FileUtil;
import org.bonitasoft.engine.bpm.bar.BusinessArchive;
import org.bonitasoft.engine.bpm.bar.BusinessArchiveFactory;
import org.bonitasoft.engine.bpm.process.DesignProcessDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildResult {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildResult.class);
    private List<BusinessArchive> businessArchives = new ArrayList<BusinessArchive>();
    private List<EnvironmentConfiguration> configurations = new ArrayList<EnvironmentConfiguration>();
    private ParametersConfiguration parametersConfiguration;
    private String environment;
    private Path workdir;

    BuildResult(String environment, ParametersConfiguration parametersConfiguration, Path workdir) {
        this.environment = Objects.requireNonNull(environment).toLowerCase();
        this.parametersConfiguration = Objects.requireNonNull(parametersConfiguration);
        this.workdir = Objects.requireNonNull(workdir);
    }

    public void addBusinessArchive(BusinessArchive businessArchive) {
        this.businessArchives.add(businessArchive);
    }

    public void addConfiguration(EnvironmentConfiguration configuration) {
        this.configurations.add(configuration);
    }

    public List<BusinessArchive> getBusinessArchives() {
        return this.businessArchives;
    }

    public List<EnvironmentConfiguration> getConfigurations() {
        return this.configurations;
    }

    public void writeBusinessArchivesTo(Path barOutputFolder) throws IOException {
        for (BusinessArchive archive : this.businessArchives) {
            this.writeBar(barOutputFolder, archive);
        }
    }

    public void writeBonitaConfigurationTo(Path bonitaConfigurationFile) throws IOException {
        Path configurationTmpFolder = this.workdir.resolve("bconf");
        if (Files.exists(bonitaConfigurationFile, new LinkOption[0])) {
            FileUtil.deleteDir((Path)bonitaConfigurationFile);
        }
        Files.createDirectories(configurationTmpFolder, new FileAttribute[0]);
        try {
            for (EnvironmentConfiguration configuration : this.configurations) {
                this.writeConfiguration(configurationTmpFolder, configuration);
            }
            Path envFolder = configurationTmpFolder.resolve(this.environment);
            if (Files.exists(envFolder, new LinkOption[0]) && envFolder.toFile().list().length > 0) {
                LOGGER.info("Writing Bonita configuration file for {} environment to {}", (Object)this.environment, (Object)bonitaConfigurationFile);
                new ConfigurationArchiveBuilder().withEnv(envFolder).withParametersConfiguration(this.parametersConfiguration).create(bonitaConfigurationFile);
            } else {
                LOGGER.warn("No configuration found for {} environment.", (Object)this.environment);
            }
        }
        finally {
            FileUtil.deleteDir((Path)configurationTmpFolder);
        }
    }

    private void writeBar(Path targetFolder, BusinessArchive archive) throws IOException {
        File newBar;
        DesignProcessDefinition processDefinition = archive.getProcessDefinition();
        String name = processDefinition.getName();
        String version = processDefinition.getVersion();
        String fileName = String.format("%s--%s.bar", name, version);
        if (!Files.exists(targetFolder, new LinkOption[0])) {
            Files.createDirectories(targetFolder, new FileAttribute[0]);
        }
        if ((newBar = targetFolder.resolve(fileName).toFile()).exists()) {
            Files.delete(newBar.toPath());
        }
        LOGGER.info("Writing bar file {} in {}", (Object)fileName, (Object)targetFolder);
        BusinessArchiveFactory.writeBusinessArchiveToFile((BusinessArchive)archive, (File)newBar);
    }

    private void writeConfiguration(Path targetFolder, EnvironmentConfiguration configuration) throws IOException {
        if (!Files.exists(targetFolder, new LinkOption[0])) {
            Files.createDirectories(targetFolder, new FileAttribute[0]);
        }
        configuration.writeParameters(targetFolder);
    }

    public void add(BuildResult result) {
        this.businessArchives.addAll(result.getBusinessArchives());
        this.configurations.addAll(result.getConfigurations());
    }
}

