/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bar;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public interface ClasspathResolver {
    public File findJarFile(String var1) throws IOException;

    public List<File> listFiles() throws IOException;

    public static ClasspathResolver of(final List<String> classpath) {
        return new ClasspathResolver(){

            @Override
            public File findJarFile(String fileName) throws IOException {
                return this.listFiles().stream().filter(file -> Objects.equals(file.getName(), fileName)).findFirst().orElse(null);
            }

            @Override
            public List<File> listFiles() throws IOException {
                return classpath.stream().map(File::new).collect(Collectors.toList());
            }
        };
    }
}

