/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bar;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import java.util.zip.ZipEntry;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.bonitasoft.bpm.connector.model.implementation.ConnectorImplementation;
import org.bonitasoft.bpm.connector.model.implementation.DocumentRoot;
import org.bonitasoft.bpm.connector.model.implementation.util.ConnectorImplementationResourceFactoryImpl;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.emf.ecore.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ConnectorImplementationRegistry {
    public static final Logger LOGGER = LoggerFactory.getLogger(ConnectorImplementationRegistry.class);
    public static final ConnectorImplementationResourceFactoryImpl RESOURCE_FACTORY = new ConnectorImplementationResourceFactoryImpl();

    public Optional<ConnectorImplementation> find(String var1, String var2);

    public List<ConnectorImplementation> findAll(Predicate<ArtifactInfo> var1);

    public static ConnectorImplementationRegistry of(final List<ConnectorImplementationJar> implementations) {
        return new ConnectorImplementationRegistry(){

            @Override
            public Optional<ConnectorImplementation> find(String id, String version) {
                return implementations.stream().filter(impl -> Objects.equals(impl.getId(), id) && Objects.equals(impl.getVersion(), version)).map(this::loadImplementation).filter(Objects::nonNull).findFirst();
            }

            @Override
            public List<ConnectorImplementation> findAll(Predicate<ArtifactInfo> predicate) {
                return implementations.stream().filter(impl -> predicate.test(impl.getArtifactInformation())).map(this::loadImplementation).filter(Objects::nonNull).toList();
            }

            /*
             * Loose catch block
             */
            private ConnectorImplementation loadImplementation(ConnectorImplementationJar implementation) {
                try {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try {
                        ConnectorImplementation connectorImplementation;
                        InputStream is;
                        JarFile jar;
                        block18: {
                            block17: {
                                jar = new JarFile(implementation.getJarFile());
                                is = jar.getInputStream(jar.getEntry(implementation.getEntry()));
                                Resource resource = RESOURCE_FACTORY.createResource(null);
                                resource.load(is, Collections.emptyMap());
                                connectorImplementation = ((DocumentRoot)resource.getContents().get(0)).getConnectorImplementation();
                                if (is == null) break block17;
                                is.close();
                            }
                            if (jar == null) break block18;
                            jar.close();
                        }
                        return connectorImplementation;
                        {
                            catch (Throwable throwable2) {
                                try {
                                    if (is != null) {
                                        is.close();
                                    }
                                    throw throwable2;
                                }
                                catch (Throwable throwable3) {
                                    if (throwable == null) {
                                        throwable = throwable3;
                                    } else if (throwable != throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    if (jar != null) {
                                        jar.close();
                                    }
                                    throw throwable;
                                }
                            }
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Failed to parse connector implementation", (Throwable)e);
                    return null;
                }
            }
        };
    }

    public record ArtifactInfo(String groupId, String artifactId, String version, String classifier, String file) {
        public static Predicate<ArtifactInfo> matchesDep(Dependency dep) {
            return info -> Objects.equals(dep.getGroupId(), info.groupId()) && Objects.equals(dep.getArtifactId(), info.artifactId()) && Objects.equals(dep.getVersion(), info.version()) && Objects.equals(dep.getClassifier(), info.classifier());
        }
    }

    public static class ConnectorImplementationJar {
        private final String id;
        private final String version;
        private final ArtifactInfo artifactInformation;
        private final String entry;

        public static ConnectorImplementationJar of(String id, String version, ArtifactInfo artifactInformation, String entry) {
            return new ConnectorImplementationJar(id, version, artifactInformation, entry);
        }

        @Deprecated
        public static ConnectorImplementationJar of(String id, String version, File jarFile, String entry) {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (JarFile jar = new JarFile(jarFile);){
                    Stream<JarEntry> jarEntries = StreamSupport.stream(Spliterators.spliteratorUnknownSize(jar.entries().asIterator(), 16), false);
                    List<JarEntry> inMavenEntries = jarEntries.filter(e -> e.getName().contains("META-INF/maven/")).toList();
                    Optional<ArtifactInfo> artifactInfoOpt = ConnectorImplementationJar.getArtifactInfoFromProperties(jarFile, jar, inMavenEntries);
                    artifactInfoOpt = artifactInfoOpt.or(() -> ConnectorImplementationJar.getArtifactInfoFromPomXml(jarFile, jar, inMavenEntries));
                    artifactInfoOpt = artifactInfoOpt.or(() -> ConnectorImplementationJar.getArtifactInfoFromFileLocation(jarFile));
                    ArtifactInfo artifactInfo = artifactInfoOpt.orElseThrow(() -> {
                        String msg = MessageFormat.format("Failed to get artifact information for {0}", jarFile.getAbsolutePath());
                        return new IllegalArgumentException(msg);
                    });
                    return new ConnectorImplementationJar(id, version, artifactInfo, entry);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e2) {
                String msg = MessageFormat.format("Failed to get artifact information for {0}", jarFile.getAbsolutePath());
                LOGGER.error(msg, (Throwable)e2);
                throw new IllegalArgumentException(msg);
            }
        }

        private static Optional<ArtifactInfo> getArtifactInfoFromPomXml(File jarFile, JarFile jar, List<JarEntry> inMavenEntries) {
            Optional<JarEntry> pomEntry = inMavenEntries.stream().filter(e -> e.getName().endsWith("pom.xml")).findFirst();
            return pomEntry.map(e -> {
                ConnectorImplementationJar.preventZipBombAttack(jar, e);
                MavenXpp3Reader reader = new MavenXpp3Reader();
                try {
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (InputStreamReader entryReader = new InputStreamReader(jar.getInputStream((ZipEntry)e));){
                        Model model = reader.read((Reader)entryReader);
                        return new ArtifactInfo(model.getGroupId(), model.getArtifactId(), model.getVersion(), null, jarFile.getAbsolutePath());
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException | XmlPullParserException e1) {
                    LOGGER.error("Failed to read pom.xml", e1);
                    return null;
                }
            }).filter(Objects::nonNull);
        }

        private static Optional<ArtifactInfo> getArtifactInfoFromProperties(File jarFile, JarFile jar, List<JarEntry> inMavenEntries) {
            Optional<JarEntry> propertiesEntry = inMavenEntries.stream().filter(e -> e.getName().endsWith("pom.properties")).findFirst();
            return propertiesEntry.map(e -> {
                ConnectorImplementationJar.preventZipBombAttack(jar, e);
                try {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (InputStreamReader entryReader = new InputStreamReader(jar.getInputStream((ZipEntry)e));){
                        Properties properties = new Properties();
                        properties.load(entryReader);
                        return new ArtifactInfo(properties.getProperty("groupId"), properties.getProperty("artifactId"), properties.getProperty("version"), properties.getProperty("classifier"), jarFile.getAbsolutePath());
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e1) {
                    LOGGER.error("Failed to read pom.properties", (Throwable)e1);
                    return null;
                }
            }).filter(Objects::nonNull);
        }

        private static Optional<ArtifactInfo> getArtifactInfoFromFileLocation(File jarFile) {
            File versionFolder = jarFile.getParentFile();
            if (versionFolder != null) {
                String jarVersion = versionFolder.getName();
                File artifactFolder = versionFolder.getParentFile();
                if (artifactFolder != null) {
                    String jarArtifactId = artifactFolder.getName();
                    File groupFolder = artifactFolder.getParentFile();
                    if (groupFolder != null) {
                        String jarGroupId = ConnectorImplementationJar.getGroupId(groupFolder);
                        String supposedFileName = jarArtifactId + "-" + jarVersion + "(?:-([\\w]*))?.jar";
                        Matcher matcher = Pattern.compile(supposedFileName).matcher(jarFile.getName());
                        if (matcher.matches()) {
                            String classifier = matcher.group(1);
                            return Optional.of(new ArtifactInfo(jarGroupId, jarArtifactId, jarVersion, classifier, jarFile.getAbsolutePath()));
                        }
                    }
                }
            }
            return Optional.empty();
        }

        private static void preventZipBombAttack(JarFile jar, JarEntry entry) {
            int thresholdSize = 1000000;
            double thresholdRatio = 10.0;
            byte[] buffer = new byte[2048];
            int totalSizeEntry = 0;
            int nBytes = -1;
            try {
                Throwable throwable = null;
                Object var9_10 = null;
                try (BufferedInputStream in = new BufferedInputStream(jar.getInputStream(entry));){
                    Path output = Files.createTempFile("outputForTesting", ".txt", new FileAttribute[0]);
                    try {
                        Throwable throwable2 = null;
                        Object var13_17 = null;
                        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(output.toFile()));){
                            while ((nBytes = ((InputStream)in).read(buffer)) > 0) {
                                ((OutputStream)out).write(buffer, 0, nBytes);
                                double compressionRatio = Double.valueOf(totalSizeEntry += nBytes) / (double)entry.getCompressedSize();
                                if (!(compressionRatio > thresholdRatio) && totalSizeEntry <= thresholdSize) continue;
                                throw new IllegalArgumentException("Zip Bomb Attack detected");
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    finally {
                        Files.delete(output);
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                String msg = "Zip Bomb Attack detection failed with exception";
                LOGGER.error(msg, (Throwable)e);
                throw new IllegalArgumentException(msg);
            }
        }

        private static String getGroupId(File groupFolder) {
            StringBuilder nameBuilder = new StringBuilder(groupFolder.getName());
            File parentFolder = groupFolder.getParentFile();
            Predicate<File> isRepositoryRoot = d -> {
                Stream<String> commonRootFolders = Stream.of("org", "com", "fr");
                return commonRootFolders.map(n -> new File((File)d, (String)n)).anyMatch(f -> f.exists() && f.isDirectory());
            };
            while (!isRepositoryRoot.test(parentFolder)) {
                nameBuilder.insert(0, '.');
                nameBuilder.insert(0, parentFolder.getName());
                parentFolder = parentFolder.getParentFile();
            }
            return nameBuilder.toString();
        }

        private ConnectorImplementationJar(String id, String version, ArtifactInfo artifactInformation, String entry) {
            this.id = id;
            this.version = version;
            this.artifactInformation = artifactInformation;
            this.entry = entry;
        }

        public String getId() {
            return this.id;
        }

        public String getVersion() {
            return this.version;
        }

        public File getJarFile() {
            return new File(this.artifactInformation.file());
        }

        public ArtifactInfo getArtifactInformation() {
            return this.artifactInformation;
        }

        public String getEntry() {
            return this.entry;
        }

        public int hashCode() {
            return Objects.hash(this.entry, this.id, this.artifactInformation, this.version);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConnectorImplementationJar other = (ConnectorImplementationJar)obj;
            return Objects.equals(this.entry, other.entry) && Objects.equals(this.id, other.id) && Objects.equals(this.artifactInformation, other.artifactInformation) && Objects.equals(this.version, other.version);
        }
    }
}

