/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bar.classpath;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bonitasoft.bonita2bar.BarArtifactProvider;
import org.bonitasoft.bonita2bar.BuildBarException;
import org.bonitasoft.bonita2bar.ConnectorImplementationRegistry;
import org.bonitasoft.bpm.connector.model.implementation.ConnectorImplementation;
import org.bonitasoft.bpm.connector.model.implementation.util.ConnectorImplementationResourceFactoryImpl;
import org.bonitasoft.bpm.connector.model.implementation.util.ConnectorImplementationXMLProcessor;
import org.bonitasoft.bpm.model.configuration.Configuration;
import org.bonitasoft.bpm.model.configuration.DefinitionMapping;
import org.bonitasoft.bpm.model.process.Pool;
import org.bonitasoft.engine.bpm.bar.BarResource;
import org.bonitasoft.engine.bpm.bar.BusinessArchiveBuilder;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorImplementationArtifactProvider
implements BarArtifactProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectorImplementationArtifactProvider.class);
    private ConnectorImplementationResourceFactoryImpl resourceFactory;
    private ConnectorImplementationXMLProcessor xmlProcessor;
    private ConnectorImplementationRegistry implRegistry;
    private String type;

    public ConnectorImplementationArtifactProvider(ConnectorImplementationRegistry implRegistry, String type) {
        this.type = type;
        this.implRegistry = implRegistry;
        this.resourceFactory = new ConnectorImplementationResourceFactoryImpl();
        this.xmlProcessor = new ConnectorImplementationXMLProcessor();
    }

    @Override
    public void build(BusinessArchiveBuilder builder, Pool process, Configuration configuration) throws BuildBarException {
        if (configuration == null) {
            return;
        }
        for (BarResource connectorImplemetation : this.createImplementationResources(configuration)) {
            if ("CONNECTOR".equals(this.type)) {
                builder.addConnectorImplementation(connectorImplemetation);
                continue;
            }
            if ("ACTOR_FILTER".equals(this.type)) {
                builder.addUserFilters(connectorImplemetation);
                continue;
            }
            throw new IllegalStateException(String.format("Unknown resource type: %s", this.type));
        }
    }

    private List<BarResource> createImplementationResources(Configuration configuration) throws BuildBarException {
        ArrayList<BarResource> implResources = new ArrayList<BarResource>();
        List mappings = configuration.getDefinitionMappings().stream().filter(mapping -> Objects.equals(this.type, mapping.getType())).filter(mapping -> Optional.ofNullable(mapping.getImplementationId()).isPresent() && Optional.ofNullable(mapping.getDefinitionVersion()).isPresent()).collect(Collectors.toList());
        for (DefinitionMapping association : mappings) {
            String connectorImplementationFilename = ConnectorImplementationArtifactProvider.toConnectorImplementationFilename(association.getImplementationId(), association.getImplementationVersion(), true);
            String implId = association.getImplementationId();
            String implVersion = association.getImplementationVersion();
            ConnectorImplementation implementation = this.implRegistry.find(implId, implVersion).orElseThrow(() -> new BuildBarException(String.format("Implementation %s (%s) not found in repository", association.getImplementationId(), association.getImplementationVersion())));
            try {
                BarResource connectorImpl = this.createImplementationResource(connectorImplementationFilename, implementation);
                implResources.add(connectorImpl);
            }
            catch (IOException e) {
                throw new BuildBarException(String.format("Failed to add implementation %s-%s in bar file", association.getImplementationId(), association.getImplementationVersion()), e);
            }
        }
        return implResources;
    }

    private BarResource createImplementationResource(String connectorImplementationFilename, ConnectorImplementation implementation) throws IOException {
        if ("CONNECTOR".equals(this.type)) {
            LOGGER.info("Adding connector implementation {}...", (Object)connectorImplementationFilename);
            return this.newBarResource(connectorImplementationFilename, implementation);
        }
        if ("ACTOR_FILTER".equals(this.type)) {
            LOGGER.info("Adding actor filter implementation {}...", (Object)connectorImplementationFilename);
            return this.newBarResource(connectorImplementationFilename, implementation);
        }
        return null;
    }

    private BarResource newBarResource(String connectorImplementationFilename, ConnectorImplementation implementation) throws IOException {
        return new BarResource(connectorImplementationFilename, this.toXMLString(implementation).getBytes(StandardCharsets.UTF_8));
    }

    private String toXMLString(ConnectorImplementation connectorImplementation) throws IOException {
        XMLResource resource = (XMLResource)this.resourceFactory.createResource(URI.createURI((String)"tmp.impl"));
        resource.getContents().add((Object)connectorImplementation);
        Map options = resource.getDefaultSaveOptions();
        options.put("ENCODING", "UTF-8");
        try {
            String string = this.xmlProcessor.saveToString((Resource)resource, options).replace("implementation:ConnectorImplementation", "implementation:connectorImplementation");
            return string;
        }
        finally {
            resource.delete(options);
        }
    }

    private static String toConnectorImplementationFilename(String implementationId, String implementationVersion, boolean inculdeExtension) {
        return implementationId + "-" + implementationVersion + (inculdeExtension ? ".impl" : "");
    }
}

