/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bar.configuration;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Properties;
import org.bonitasoft.bonita2bar.BarBuilder;
import org.bonitasoft.bonita2bar.configuration.ParametersConfigurationMapper;
import org.bonitasoft.bonita2bar.configuration.ZipUtil;
import org.bonitasoft.bonita2bar.configuration.model.ParametersConfiguration;

public class ConfigurationArchiveBuilder {
    private ParametersConfigurationMapper mapper = new ParametersConfigurationMapper();
    private Path envFolder;
    private ParametersConfiguration parametersConfiguration;

    public ConfigurationArchiveBuilder withEnv(Path envFolder) {
        this.envFolder = envFolder;
        return this;
    }

    public ConfigurationArchiveBuilder withParametersConfiguration(ParametersConfiguration parametersConfiguration) {
        this.parametersConfiguration = parametersConfiguration;
        return this;
    }

    public void create(Path configurationFile) throws IOException {
        this.addArchiveManifest(this.envFolder);
        this.mapper.writeToFile(this.parametersConfiguration, this.envFolder.resolve("parameters.yml"));
        ZipUtil.zip(this.envFolder, configurationFile);
    }

    private void addArchiveManifest(Path envFolder) throws IOException {
        File manifestFile = envFolder.resolve("MANIFEST").toFile();
        Properties props = new Properties();
        props.put("builder.version", BarBuilder.builderVersion());
        props.put("target.environment", envFolder.toFile().getName());
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileOutputStream out = new FileOutputStream(manifestFile);){
            props.store(out, null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

