/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bar.process;

import org.bonitasoft.bonita2bar.BarArtifactProvider;
import org.bonitasoft.bonita2bar.BuildBarException;
import org.bonitasoft.bonita2bar.ProcessRegistry;
import org.bonitasoft.bonita2bar.process.builder.DesignProcessDefinitionBuilder;
import org.bonitasoft.bonita2bar.process.builder.DocumentEngineDefinitionBuilder;
import org.bonitasoft.bonita2bar.process.builder.ProcessContractEngineBuilder;
import org.bonitasoft.bonita2bar.process.builder.TaskContractEngineDefinitionBuilder;
import org.bonitasoft.bpm.model.configuration.Configuration;
import org.bonitasoft.bpm.model.process.AbstractProcess;
import org.bonitasoft.bpm.model.process.Pool;
import org.bonitasoft.bpm.model.util.IModelSearch;
import org.bonitasoft.bpm.model.util.ModelSearch;
import org.bonitasoft.engine.bpm.bar.BusinessArchiveBuilder;
import org.bonitasoft.engine.bpm.process.InvalidProcessDefinitionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessDefinitionArtifactProvider
implements BarArtifactProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessDefinitionArtifactProvider.class);
    private ProcessRegistry processRegistry;

    public ProcessDefinitionArtifactProvider(ProcessRegistry processRegistry) {
        this.processRegistry = processRegistry;
    }

    @Override
    public void build(BusinessArchiveBuilder builder, Pool process, Configuration configuration) throws BuildBarException {
        LOGGER.info("Adding process definition...");
        ModelSearch modelSearch = new ModelSearch(this.processRegistry::getProcesses);
        DesignProcessDefinitionBuilder designProcessDefinitionBuilder = new DesignProcessDefinitionBuilder((IModelSearch)modelSearch, new ProcessContractEngineBuilder(), new TaskContractEngineDefinitionBuilder(), new DocumentEngineDefinitionBuilder());
        try {
            builder.setProcessDefinition(designProcessDefinitionBuilder.createDefinition((AbstractProcess)process));
        }
        catch (InvalidProcessDefinitionException e) {
            throw new BuildBarException(String.format("Invalid process definition for %s", process.getName()), e);
        }
    }
}

