/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.bonita2bar.process.builder;

import java.util.List;
import org.bonitasoft.bonita2bar.process.builder.AbstractProcessBuilder;
import org.bonitasoft.bonita2bar.process.builder.DocumentEngineDefinitionBuilder;
import org.bonitasoft.bonita2bar.process.builder.EngineFlowElementBuilder;
import org.bonitasoft.bonita2bar.process.builder.EngineProcessBuilder;
import org.bonitasoft.bonita2bar.process.builder.EngineSequenceFlowBuilder;
import org.bonitasoft.bonita2bar.process.builder.ProcessContractEngineBuilder;
import org.bonitasoft.bonita2bar.process.builder.TaskContractEngineDefinitionBuilder;
import org.bonitasoft.bpm.model.process.AbstractProcess;
import org.bonitasoft.bpm.model.process.Connection;
import org.bonitasoft.bpm.model.process.FlowElement;
import org.bonitasoft.bpm.model.process.SourceElement;
import org.bonitasoft.bpm.model.process.SubProcessEvent;
import org.bonitasoft.bpm.model.util.IModelSearch;
import org.bonitasoft.engine.bpm.process.DesignProcessDefinition;
import org.bonitasoft.engine.bpm.process.InvalidProcessDefinitionException;
import org.bonitasoft.engine.bpm.process.impl.FlowElementBuilder;
import org.bonitasoft.engine.bpm.process.impl.ProcessDefinitionBuilder;
import org.eclipse.emf.ecore.EObject;

public class DesignProcessDefinitionBuilder {
    private IModelSearch modelSearch;
    private TaskContractEngineDefinitionBuilder taskContractBuilder;
    private ProcessContractEngineBuilder processContractBuilder;
    private DocumentEngineDefinitionBuilder documentBuilder;

    public DesignProcessDefinitionBuilder(IModelSearch modelSearch, ProcessContractEngineBuilder processContractBuilder, TaskContractEngineDefinitionBuilder taskContractBuilder, DocumentEngineDefinitionBuilder documentBuilder) {
        this.modelSearch = modelSearch;
        this.processContractBuilder = processContractBuilder;
        this.taskContractBuilder = taskContractBuilder;
        this.documentBuilder = documentBuilder;
    }

    public IModelSearch getModelSearch() {
        return this.modelSearch;
    }

    public DesignProcessDefinition createDefinition(AbstractProcess process) throws InvalidProcessDefinitionException {
        ProcessDefinitionBuilder processBuilder = this.createProcessDefinitionBuilderInstance(process);
        String decription = process.getDocumentation();
        if (decription != null) {
            processBuilder.addDescription(decription);
            processBuilder.addDisplayDescription(decription);
        }
        this.newEngineProcessBuilder(processBuilder, this.processContractBuilder, this.documentBuilder).doSwitch((EObject)process);
        this.processFlowElements(process, processBuilder, this.taskContractBuilder);
        this.processSequenceFlows(process, processBuilder);
        return processBuilder.done();
    }

    protected ProcessDefinitionBuilder createProcessDefinitionBuilderInstance(AbstractProcess process) {
        return new ProcessDefinitionBuilder().createNewInstance(process.getName(), process.getVersion());
    }

    protected EngineProcessBuilder newEngineProcessBuilder(ProcessDefinitionBuilder processBuilder, ProcessContractEngineBuilder contractBuilder, DocumentEngineDefinitionBuilder documentBuilder) {
        return new EngineProcessBuilder(processBuilder, contractBuilder, documentBuilder, this.modelSearch);
    }

    protected void processFlowElements(AbstractProcess process, ProcessDefinitionBuilder processBuilder, TaskContractEngineDefinitionBuilder contractBuilder) {
        List flowElements = this.modelSearch.getAllItemsOfType((EObject)process, FlowElement.class);
        AbstractProcessBuilder flowElementSwitch = this.newEngineFlowElementBuilder(processBuilder, contractBuilder);
        for (FlowElement flowElement : flowElements) {
            if (this.modelSearch.isInEvenementialSubProcessPool((EObject)flowElement)) continue;
            flowElementSwitch.doSwitch((EObject)flowElement);
        }
        List elements = this.modelSearch.getAllItemsOfType((EObject)process, SubProcessEvent.class);
        for (SubProcessEvent flowElement : elements) {
            flowElementSwitch.doSwitch((EObject)flowElement);
        }
    }

    protected AbstractProcessBuilder newEngineFlowElementBuilder(ProcessDefinitionBuilder processBuilder, TaskContractEngineDefinitionBuilder contractBuilder) {
        return new EngineFlowElementBuilder((FlowElementBuilder)processBuilder, contractBuilder, this.modelSearch);
    }

    protected void processSequenceFlows(AbstractProcess process, ProcessDefinitionBuilder processBuilder) {
        List sourceElements = this.modelSearch.getAllItemsOfType((EObject)process, SourceElement.class);
        EngineSequenceFlowBuilder sequenceFlowSwitch = new EngineSequenceFlowBuilder((FlowElementBuilder)processBuilder);
        for (SourceElement sourceElement : sourceElements) {
            for (Connection connection : sourceElement.getOutgoing()) {
                if (this.modelSearch.isInEvenementialSubProcessPool((EObject)connection.getSource())) continue;
                sequenceFlowSwitch.doSwitch((EObject)connection);
            }
        }
    }
}

